/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;

public class InclusiveMetricsEvaluator {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private final boolean caseSensitive;
    private transient ThreadLocal<MetricsEvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private MetricsEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new MetricsEvalVisitor());
        }
        return this.visitors.get();
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.caseSensitive = caseSensitive;
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(unbound), caseSensitive);
    }

    public boolean eval(DataFile file2) {
        return this.visitor().eval(file2);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(DataFile file2) {
            if (file2.recordCount() <= 0L) {
                return false;
            }
            this.valueCounts = file2.valueCounts();
            this.nullCounts = file2.nullValueCounts();
            this.lowerBounds = file2.lowerBounds();
            this.upperBounds = file2.upperBounds();
            return ExpressionVisitors.visitEvaluator(InclusiveMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref2) {
            Integer id = ref2.fieldId();
            if (this.nullCounts != null && this.nullCounts.containsKey(id) && this.nullCounts.get(id) == 0L) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref2) {
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref2.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref2.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref2.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref2.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref2, Literal<T> lit) {
            int cmp;
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref2.type(), this.lowerBounds.get(id));
                cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref2.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref2, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref2, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref2, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref2, Literal<T> lit) {
            ByteBuffer upper;
            int length;
            ByteBuffer lower;
            int cmp;
            Integer id = ref2.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            ByteBuffer prefixAsBytes = lit.toByteBuffer();
            Comparator<ByteBuffer> comparator2 = Comparators.unsignedBytes();
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id) && (cmp = comparator2.compare(BinaryUtil.truncateBinary(lower = this.lowerBounds.get(id), length = Math.min(prefixAsBytes.remaining(), lower.remaining())), prefixAsBytes)) > 0) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id) && (cmp = comparator2.compare(BinaryUtil.truncateBinary(upper = this.upperBounds.get(id), length = Math.min(prefixAsBytes.remaining(), upper.remaining())), prefixAsBytes)) < 0) {
                return false;
            }
            return true;
        }

        private boolean containsNullsOnly(Integer id) {
            return this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L;
        }
    }
}

