/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Types;

public class Evaluator
implements Serializable {
    private final Expression expr;
    private transient ThreadLocal<EvalVisitor> visitors = null;

    private EvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new EvalVisitor());
        }
        return this.visitors.get();
    }

    public Evaluator(Types.StructType struct2, Expression unbound) {
        this.expr = Binder.bind(struct2, unbound, true);
    }

    public Evaluator(Types.StructType struct2, Expression unbound, boolean caseSensitive) {
        this.expr = Binder.bind(struct2, unbound, caseSensitive);
    }

    public boolean eval(StructLike data2) {
        return this.visitor().eval(data2);
    }

    private class EvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private StructLike struct;

        private EvalVisitor() {
        }

        private boolean eval(StructLike row) {
            this.struct = row;
            return ExpressionVisitors.visitEvaluator(Evaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref2) {
            return ref2.get(this.struct) == null;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref2) {
            return ref2.get(this.struct) != null;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref2, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref2.get(this.struct), lit.value()) < 0;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref2, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref2.get(this.struct), lit.value()) <= 0;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref2, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref2.get(this.struct), lit.value()) > 0;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref2, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref2.get(this.struct), lit.value()) >= 0;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref2, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref2.get(this.struct), lit.value()) == 0;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref2, Literal<T> lit) {
            return !((Boolean)this.eq((BoundReference)ref2, (Literal)lit)).booleanValue();
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref2, Literal<T> lit) {
            throw new UnsupportedOperationException("In is not supported yet");
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref2, Literal<T> lit) {
            return !((Boolean)this.in((BoundReference)ref2, (Literal)lit)).booleanValue();
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref2, Literal<T> lit) {
            return ((String)ref2.get(this.struct)).startsWith((String)lit.value());
        }
    }
}

