/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionSpec
implements Serializable {
    private static final int PARTITION_DATA_ID_START = 1000;
    private final Schema schema;
    private final int specId;
    private final PartitionField[] fields;
    private volatile transient ListMultimap<Integer, PartitionField> fieldsBySourceId = null;
    private volatile transient Map<String, PartitionField> fieldsByName = null;
    private volatile transient Class<?>[] lazyJavaClasses = null;
    private volatile transient List<PartitionField> fieldList = null;
    private static final PartitionSpec UNPARTITIONED_SPEC = new PartitionSpec(new Schema(new Types.NestedField[0]), 0, ImmutableList.of());

    private PartitionSpec(Schema schema, int specId, List<PartitionField> fields) {
        this.schema = schema;
        this.specId = specId;
        this.fields = new PartitionField[fields.size()];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = fields.get(i);
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public int specId() {
        return this.specId;
    }

    public List<PartitionField> fields() {
        return this.lazyFieldList();
    }

    public List<PartitionField> getFieldsBySourceId(int fieldId) {
        return this.lazyFieldsBySourceId().get((Object)fieldId);
    }

    public Types.StructType partitionType() {
        ArrayList<Types.NestedField> structFields = Lists.newArrayListWithExpectedSize(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            PartitionField field = this.fields[i];
            Type sourceType = this.schema.findType(field.sourceId());
            Type resultType = field.transform().getResultType(sourceType);
            structFields.add(Types.NestedField.optional(1000 + i, field.name(), resultType));
        }
        return Types.StructType.of(structFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?>[] javaClasses() {
        if (this.lazyJavaClasses == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.lazyJavaClasses == null) {
                    Class[] classes = new Class[this.fields.length];
                    for (int i = 0; i < this.fields.length; ++i) {
                        PartitionField field = this.fields[i];
                        if (field.transform() instanceof UnknownTransform) {
                            classes[i] = Object.class;
                            continue;
                        }
                        Type sourceType = this.schema.findType(field.sourceId());
                        Type result = field.transform().getResultType(sourceType);
                        classes[i] = result.typeId().javaClass();
                    }
                    this.lazyJavaClasses = classes;
                }
            }
        }
        return this.lazyJavaClasses;
    }

    private <T> T get(StructLike data2, int pos, Class<?> javaClass) {
        return (T)data2.get(pos, javaClass);
    }

    private String escape(String string2) {
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public String partitionToPath(StructLike data2) {
        StringBuilder sb = new StringBuilder();
        Class<?>[] javaClasses = this.javaClasses();
        for (int i = 0; i < javaClasses.length; ++i) {
            PartitionField field = this.fields[i];
            String valueString = field.transform().toHumanString(this.get(data2, i, javaClasses[i]));
            if (i > 0) {
                sb.append("/");
            }
            sb.append(field.name()).append("=").append(this.escape(valueString));
        }
        return sb.toString();
    }

    public boolean compatibleWith(PartitionSpec other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.fields.length != other.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            PartitionField thisField = this.fields[i];
            PartitionField thatField = other.fields[i];
            if (thisField.sourceId() == thatField.sourceId() && thisField.transform().toString().equals(thatField.transform().toString())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionSpec that = (PartitionSpec)other;
        if (this.specId != that.specId) {
            return false;
        }
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode(Arrays.hashCode(this.fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PartitionField> lazyFieldList() {
        if (this.fieldList == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.fieldList == null) {
                    this.fieldList = ImmutableList.copyOf(this.fields);
                }
            }
        }
        return this.fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PartitionField> lazyFieldsByName() {
        if (this.fieldsByName == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.fieldsByName == null) {
                    ImmutableMap.Builder<String, PartitionField> builder = ImmutableMap.builder();
                    for (PartitionField field : this.fields) {
                        builder.put(field.name(), field);
                    }
                    this.fieldsByName = builder.build();
                }
            }
        }
        return this.fieldsByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListMultimap<Integer, PartitionField> lazyFieldsBySourceId() {
        if (this.fieldsBySourceId == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.fieldsBySourceId == null) {
                    ListMultimap<Integer, PartitionField> multiMap = Multimaps.newListMultimap(Maps.newHashMap(), () -> Lists.newArrayListWithCapacity(this.fields.length));
                    for (PartitionField field : this.fields) {
                        multiMap.put(field.sourceId(), field);
                    }
                    this.fieldsBySourceId = multiMap;
                }
            }
        }
        return this.fieldsBySourceId;
    }

    public Set<Integer> identitySourceIds() {
        HashSet<Integer> sourceIds = Sets.newHashSet();
        for (PartitionField field : this.fields()) {
            if (!"identity".equals(field.transform().toString())) continue;
            sourceIds.add(field.sourceId());
        }
        return sourceIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (PartitionField field : this.fields) {
            sb.append("\n");
            sb.append("  ").append(field);
        }
        if (this.fields.length > 0) {
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static PartitionSpec unpartitioned() {
        return UNPARTITIONED_SPEC;
    }

    public static Builder builderFor(Schema schema) {
        return new Builder(schema);
    }

    static void checkCompatibility(PartitionSpec spec, Schema schema) {
        for (PartitionField field : spec.fields) {
            Type sourceType = schema.findType(field.sourceId());
            ValidationException.check(sourceType != null, "Cannot find source column for partition field: %s", field);
            ValidationException.check(sourceType.isPrimitiveType(), "Cannot partition by non-primitive source field: %s", sourceType);
            ValidationException.check(field.transform().canTransform(sourceType), "Invalid source type %s for transform: %s", sourceType, field.transform());
        }
    }

    public static class Builder {
        private final Schema schema;
        private final List<PartitionField> fields = Lists.newArrayList();
        private final Set<String> partitionNames = Sets.newHashSet();
        private Map<Integer, PartitionField> timeFields = Maps.newHashMap();
        private int specId = 0;

        private Builder(Schema schema) {
            this.schema = schema;
        }

        private void checkAndAddPartitionName(String name2) {
            this.checkAndAddPartitionName(name2, null);
        }

        private void checkAndAddPartitionName(String name2, Integer identitySourceColumnId) {
            Types.NestedField schemaField = this.schema.findField(name2);
            if (identitySourceColumnId != null) {
                Preconditions.checkArgument(schemaField == null || schemaField.fieldId() == identitySourceColumnId.intValue(), "Cannot create identity partition sourced from different field in schema: %s", (Object)name2);
            } else {
                Preconditions.checkArgument(schemaField == null, "Cannot create partition from name that exists in schema: %s", (Object)name2);
            }
            Preconditions.checkArgument(name2 != null && !name2.isEmpty(), "Cannot use empty or null partition name: %s", (Object)name2);
            Preconditions.checkArgument(!this.partitionNames.contains(name2), "Cannot use partition name more than once: %s", (Object)name2);
            this.partitionNames.add(name2);
        }

        private void checkForRedundantPartitions(PartitionField field) {
            PartitionField timeField = this.timeFields.get(field.sourceId());
            Preconditions.checkArgument(timeField == null, "Cannot add redundant partition: %s conflicts with %s", (Object)timeField, (Object)field);
            this.timeFields.put(field.sourceId(), field);
        }

        public Builder withSpecId(int newSpecId) {
            this.specId = newSpecId;
            return this;
        }

        private Types.NestedField findSourceColumn(String sourceName) {
            Types.NestedField sourceColumn = this.schema.findField(sourceName);
            Preconditions.checkArgument(sourceColumn != null, "Cannot find source column: %s", (Object)sourceName);
            return sourceColumn;
        }

        Builder identity(String sourceName, String targetName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            this.checkAndAddPartitionName(targetName, sourceColumn.fieldId());
            this.fields.add(new PartitionField(sourceColumn.fieldId(), targetName, Transforms.identity(sourceColumn.type())));
            return this;
        }

        public Builder identity(String sourceName) {
            return this.identity(sourceName, sourceName);
        }

        public Builder year(String sourceName, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), targetName, Transforms.year(sourceColumn.type()));
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder year(String sourceName) {
            return this.year(sourceName, sourceName + "_year");
        }

        public Builder month(String sourceName, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), targetName, Transforms.month(sourceColumn.type()));
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder month(String sourceName) {
            return this.month(sourceName, sourceName + "_month");
        }

        public Builder day(String sourceName, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), targetName, Transforms.day(sourceColumn.type()));
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder day(String sourceName) {
            return this.day(sourceName, sourceName + "_day");
        }

        public Builder hour(String sourceName, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), targetName, Transforms.hour(sourceColumn.type()));
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder hour(String sourceName) {
            return this.hour(sourceName, sourceName + "_hour");
        }

        public Builder bucket(String sourceName, int numBuckets, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            this.fields.add(new PartitionField(sourceColumn.fieldId(), targetName, Transforms.bucket(sourceColumn.type(), numBuckets)));
            return this;
        }

        public Builder bucket(String sourceName, int numBuckets) {
            return this.bucket(sourceName, numBuckets, sourceName + "_bucket");
        }

        public Builder truncate(String sourceName, int width, String targetName) {
            this.checkAndAddPartitionName(targetName);
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            this.fields.add(new PartitionField(sourceColumn.fieldId(), targetName, Transforms.truncate(sourceColumn.type(), width)));
            return this;
        }

        public Builder truncate(String sourceName, int width) {
            return this.truncate(sourceName, width, sourceName + "_trunc");
        }

        Builder add(int sourceId, String name2, String transform2) {
            Types.NestedField column = this.schema.findField(sourceId);
            this.checkAndAddPartitionName(name2, column.fieldId());
            Preconditions.checkNotNull(column, "Cannot find source column: %d", sourceId);
            this.fields.add(new PartitionField(sourceId, name2, Transforms.fromString(column.type(), transform2)));
            return this;
        }

        public PartitionSpec build() {
            PartitionSpec spec = new PartitionSpec(this.schema, this.specId, this.fields);
            PartitionSpec.checkCompatibility(spec, this.schema);
            return spec;
        }
    }
}

