/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

final class Bzip2HuffmanAllocator {
    private static int first(int[] array2, int i, int nodesToMove) {
        int length = array2.length;
        int limit2 = i;
        int k = array2.length - 2;
        while (i >= nodesToMove && array2[i] % length > limit2) {
            k = i;
            i -= limit2 - i + 1;
        }
        i = Math.max(nodesToMove - 1, i);
        while (k > i + 1) {
            int temp = i + k >>> 1;
            if (array2[temp] % length > limit2) {
                k = temp;
                continue;
            }
            i = temp;
        }
        return k;
    }

    private static void setExtendedParentPointers(int[] array2) {
        int length = array2.length;
        array2[0] = array2[0] + array2[1];
        int headNode = 0;
        int topNode = 2;
        for (int tailNode = 1; tailNode < length - 1; ++tailNode) {
            int temp;
            if (topNode >= length || array2[headNode] < array2[topNode]) {
                temp = array2[headNode];
                array2[headNode++] = tailNode;
            } else {
                temp = array2[topNode++];
            }
            if (topNode >= length || headNode < tailNode && array2[headNode] < array2[topNode]) {
                temp += array2[headNode];
                array2[headNode++] = tailNode + length;
            } else {
                temp += array2[topNode++];
            }
            array2[tailNode] = temp;
        }
    }

    private static int findNodesToRelocate(int[] array2, int maximumLength) {
        int currentNode = array2.length - 2;
        for (int currentDepth = 1; currentDepth < maximumLength - 1 && currentNode > 1; ++currentDepth) {
            currentNode = Bzip2HuffmanAllocator.first(array2, currentNode - 1, 0);
        }
        return currentNode;
    }

    private static void allocateNodeLengths(int[] array2) {
        int firstNode = array2.length - 2;
        int nextNode = array2.length - 1;
        int currentDepth = 1;
        int availableNodes = 2;
        while (availableNodes > 0) {
            int lastNode = firstNode;
            firstNode = Bzip2HuffmanAllocator.first(array2, lastNode - 1, 0);
            for (int i = availableNodes - (lastNode - firstNode); i > 0; --i) {
                array2[nextNode--] = currentDepth;
            }
            availableNodes = lastNode - firstNode << 1;
            ++currentDepth;
        }
    }

    private static void allocateNodeLengthsWithRelocation(int[] array2, int nodesToMove, int insertDepth) {
        int firstNode = array2.length - 2;
        int nextNode = array2.length - 1;
        int currentDepth = insertDepth == 1 ? 2 : 1;
        int nodesLeftToMove = insertDepth == 1 ? nodesToMove - 2 : nodesToMove;
        int availableNodes = currentDepth << 1;
        while (availableNodes > 0) {
            int lastNode = firstNode;
            firstNode = firstNode <= nodesToMove ? firstNode : Bzip2HuffmanAllocator.first(array2, lastNode - 1, nodesToMove);
            int offset = 0;
            if (currentDepth >= insertDepth) {
                offset = Math.min(nodesLeftToMove, 1 << currentDepth - insertDepth);
            } else if (currentDepth == insertDepth - 1) {
                offset = 1;
                if (array2[firstNode] == lastNode) {
                    ++firstNode;
                }
            }
            for (int i = availableNodes - (lastNode - firstNode + offset); i > 0; --i) {
                array2[nextNode--] = currentDepth;
            }
            nodesLeftToMove -= offset;
            availableNodes = lastNode - firstNode + offset << 1;
            ++currentDepth;
        }
    }

    static void allocateHuffmanCodeLengths(int[] array2, int maximumLength) {
        switch (array2.length) {
            case 2: {
                array2[1] = 1;
            }
            case 1: {
                array2[0] = 1;
                return;
            }
        }
        Bzip2HuffmanAllocator.setExtendedParentPointers(array2);
        int nodesToRelocate = Bzip2HuffmanAllocator.findNodesToRelocate(array2, maximumLength);
        if (array2[0] % array2.length >= nodesToRelocate) {
            Bzip2HuffmanAllocator.allocateNodeLengths(array2);
        } else {
            int insertDepth = maximumLength - (32 - Integer.numberOfLeadingZeros(nodesToRelocate - 1));
            Bzip2HuffmanAllocator.allocateNodeLengthsWithRelocation(array2, nodesToRelocate, insertDepth);
        }
    }

    private Bzip2HuffmanAllocator() {
    }
}

