/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.AReference;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import io.mantisrx.mql.shaded.clojure.lang.IPersistentMap;
import io.mantisrx.mql.shaded.clojure.lang.IRef;
import io.mantisrx.mql.shaded.clojure.lang.ISeq;
import io.mantisrx.mql.shaded.clojure.lang.PersistentHashMap;
import io.mantisrx.mql.shaded.clojure.lang.RT;
import java.util.Map;

public abstract class ARef
extends AReference
implements IRef {
    protected volatile IFn validator = null;
    private volatile IPersistentMap watches = PersistentHashMap.EMPTY;

    public ARef() {
    }

    public ARef(IPersistentMap meta) {
        super(meta);
    }

    void validate(IFn vf, Object val2) {
        try {
            if (vf != null && !RT.booleanCast(vf.invoke(val2))) {
                throw new IllegalStateException("Invalid reference state");
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new IllegalStateException("Invalid reference state", e2);
        }
    }

    void validate(Object val2) {
        this.validate(this.validator, val2);
    }

    @Override
    public void setValidator(IFn vf) {
        this.validate(vf, this.deref());
        this.validator = vf;
    }

    @Override
    public IFn getValidator() {
        return this.validator;
    }

    @Override
    public IPersistentMap getWatches() {
        return this.watches;
    }

    @Override
    public synchronized IRef addWatch(Object key2, IFn callback) {
        this.watches = this.watches.assoc(key2, callback);
        return this;
    }

    @Override
    public synchronized IRef removeWatch(Object key2) {
        this.watches = this.watches.without(key2);
        return this;
    }

    public void notifyWatches(Object oldval, Object newval) {
        IPersistentMap ws = this.watches;
        if (ws.count() > 0) {
            for (ISeq s2 = ws.seq(); s2 != null; s2 = s2.next()) {
                Map.Entry e2 = (Map.Entry)s2.first();
                IFn fn2 = (IFn)e2.getValue();
                if (fn2 == null) continue;
                fn2.invoke(e2.getKey(), this, oldval, newval);
            }
        }
    }
}

