/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer;

import io.mantisrx.connector.iceberg.sink.writer.IcebergWriter;
import io.mantisrx.connector.iceberg.sink.writer.config.WriterConfig;
import io.mantisrx.runtime.WorkerInfo;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIcebergWriter
implements IcebergWriter {
    private static final Logger logger = LoggerFactory.getLogger(BaseIcebergWriter.class);
    private final WriterConfig config;
    private final WorkerInfo workerInfo;
    private final Table table;
    private final PartitionSpec spec;
    private final FileFormat format;
    private FileAppender<Record> appender;
    private OutputFile file;
    private StructLike key;

    public BaseIcebergWriter(WriterConfig config, WorkerInfo workerInfo, Table table2) {
        this.config = config;
        this.table = table2;
        this.spec = table2.spec();
        this.workerInfo = workerInfo;
        this.format = FileFormat.valueOf(config.getWriterFileFormat());
    }

    @Override
    public void open() throws IOException {
        String filename = this.generateFilename(this.workerInfo);
        String child = String.format("data/%s", filename);
        Path path2 = new Path(this.table.location(), child);
        logger.info("opening new {} file appender {}", (Object)this.format, (Object)path2);
        this.file = HadoopOutputFile.fromPath((Path)path2, (Configuration)this.config.getHadoopConfig());
        switch (this.format) {
            case PARQUET: {
                this.appender = Parquet.write((OutputFile)this.file).schema(this.table.schema()).createWriterFunc(GenericParquetWriter::buildWriter).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot write using an unsupported file format " + (Object)((Object)this.format));
            }
        }
    }

    @Override
    public abstract void write(Record var1);

    @Override
    public DataFile close() throws IOException {
        if (this.appender == null) {
            return null;
        }
        this.appender.close();
        DataFile dataFile = DataFiles.builder((PartitionSpec)this.spec).withPath(this.file.location()).withInputFile(this.file.toInputFile()).withFileSizeInBytes(this.appender.length()).withPartition(this.spec.fields().size() == 0 ? null : this.key).withMetrics(this.appender.metrics()).withSplitOffsets(this.appender.splitOffsets()).build();
        this.appender = null;
        this.file = null;
        return dataFile;
    }

    @Override
    public boolean isClosed() {
        return this.appender == null;
    }

    @Override
    public long length() {
        return this.appender == null ? 0L : this.appender.length();
    }

    protected void writeRecord(Record record) {
        this.appender.add(record);
    }

    private String generateFilename(WorkerInfo workerInfo) {
        return this.format.addExtension(String.format("%s_%s_%s_%s_%s", workerInfo.getJobId(), workerInfo.getStageNumber(), workerInfo.getWorkerIndex(), workerInfo.getWorkerNumber(), UUID.randomUUID().toString()));
    }
}

