/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.codecs;

import io.mantisrx.common.codec.Codec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.iceberg.DataFile;

public class IcebergCodecs {
    public static Codec<DataFile> dataFile() {
        return new Codec<DataFile>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public DataFile decode(byte[] bytes2) {
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes2));){
                    DataFile dataFile = (DataFile)in.readObject();
                    return dataFile;
                }
                catch (IOException | ClassNotFoundException e2) {
                    throw new RuntimeException("Failed to convert bytes to DataFile", e2);
                }
            }

            @Override
            public byte[] encode(DataFile value) {
                ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
                try (ObjectOutputStream out = new ObjectOutputStream(bytes2);){
                    out.writeObject(value);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to write bytes for DataFile: " + value, e2);
                }
                return bytes2.toByteArray();
            }
        };
    }
}

