/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.metrics.ServerMetricEventsListener;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class TcpServerListener<T extends ServerMetricsEvent<?>>
extends ServerMetricEventsListener<T> {
    private final Gauge liveConnections;
    private final Gauge inflightConnections;
    private final Counter failedConnections;
    private final Gauge pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final Gauge pendingWrites;
    private final Gauge pendingFlushes;
    private final Counter bytesWritten;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;

    protected TcpServerListener(String monitorId) {
        Metrics m3 = new Metrics.Builder().name("tcpServer_" + monitorId).addGauge("liveConnections").addGauge("inflightConnections").addCounter("failedConnections").addGauge("pendingConnectionClose").addCounter("failedConnectionClose").addGauge("pendingWrites").addGauge("pendingFlushes").addCounter("bytesWritten").addCounter("bytesRead").addCounter("failedWrites").addCounter("failedFlushes").build();
        m3 = MetricsRegistry.getInstance().registerAndGet(m3);
        this.liveConnections = m3.getGauge("liveConnections");
        this.inflightConnections = m3.getGauge("inflightConnections");
        this.failedConnections = m3.getCounter("failedConnections");
        this.pendingConnectionClose = m3.getGauge("pendingConnectionClose");
        this.failedConnectionClose = m3.getCounter("failedConnectionClose");
        this.pendingWrites = m3.getGauge("pendingWrites");
        this.pendingFlushes = m3.getGauge("pendingFlushes");
        this.bytesWritten = m3.getCounter("bytesWritten");
        this.bytesRead = m3.getCounter("bytesRead");
        this.failedWrites = m3.getCounter("failedWrites");
        this.failedFlushes = m3.getCounter("failedFlushes");
    }

    public static TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>>(monitorId);
    }

    @Override
    protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.inflightConnections.decrement();
        this.failedConnections.increment();
    }

    @Override
    protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.inflightConnections.decrement();
    }

    @Override
    protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.inflightConnections.increment();
    }

    @Override
    protected void onConnectionCloseStart() {
        this.pendingConnectionClose.increment();
    }

    @Override
    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.liveConnections.decrement();
        this.pendingConnectionClose.decrement();
    }

    @Override
    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.liveConnections.decrement();
        this.pendingConnectionClose.decrement();
        this.failedConnectionClose.increment();
    }

    @Override
    protected void onNewClientConnected() {
        this.liveConnections.increment();
    }

    @Override
    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    @Override
    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingFlushes.decrement();
        this.failedFlushes.increment();
    }

    @Override
    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        this.pendingFlushes.decrement();
    }

    @Override
    protected void onFlushStart() {
        this.pendingFlushes.increment();
    }

    @Override
    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingWrites.decrement();
        this.failedWrites.increment();
    }

    @Override
    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        this.pendingWrites.decrement();
        this.bytesWritten.increment(bytesWritten);
    }

    @Override
    protected void onWriteStart() {
        this.pendingWrites.increment();
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onSubscribe() {
    }

    public long getLiveConnections() {
        return this.liveConnections.value();
    }

    public long getInflightConnections() {
        return this.inflightConnections.value();
    }

    public long getFailedConnections() {
        return this.failedConnections.value();
    }

    public long getPendingWrites() {
        return this.pendingWrites.value();
    }

    public long getPendingFlushes() {
        return this.pendingFlushes.value();
    }

    public long getBytesWritten() {
        return this.bytesWritten.value();
    }

    public long getBytesRead() {
        return this.bytesRead.value();
    }

    public long getFailedWrites() {
        return this.failedWrites.value();
    }

    public long getFailedFlushes() {
        return this.failedFlushes.value();
    }
}

