/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.netty.TcpServerListener;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.metrics.HttpServerMetricEventsListener;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class HttpServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final Gauge requestBacklog;
    private final Gauge inflightRequests;
    private final Counter processedRequests;
    private final Counter failedRequests;
    private final Counter responseWriteFailed;
    private final HttpServerMetricEventsListenerImpl delegate;

    protected HttpServerListener(String monitorId) {
        super(monitorId);
        Metrics m3 = new Metrics.Builder().name("httpServer_" + monitorId).addGauge("requestBacklog").addGauge("inflightRequests").addCounter("processedRequests").addCounter("failedRequests").addCounter("responseWriteFailed").build();
        m3 = MetricsRegistry.getInstance().registerAndGet(m3);
        this.requestBacklog = m3.getGauge("requestBacklog");
        this.inflightRequests = m3.getGauge("inflightRequests");
        this.processedRequests = m3.getCounter("processedRequests");
        this.failedRequests = m3.getCounter("failedRequests");
        this.responseWriteFailed = m3.getCounter("responseWriteFailed");
        this.delegate = new HttpServerMetricEventsListenerImpl();
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    @Override
    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return this.requestBacklog.value();
    }

    public long getInflightRequests() {
        return this.inflightRequests.value();
    }

    public long getProcessedRequests() {
        return this.processedRequests.value();
    }

    public long getFailedRequests() {
        return this.failedRequests.value();
    }

    public long getResponseWriteFailed() {
        return this.responseWriteFailed.value();
    }

    private class HttpServerMetricEventsListenerImpl
    extends HttpServerMetricEventsListener {
        private HttpServerMetricEventsListenerImpl() {
        }

        @Override
        protected void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.processedRequests.increment();
            HttpServerListener.this.inflightRequests.decrement();
            HttpServerListener.this.failedRequests.increment();
        }

        @Override
        protected void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.inflightRequests.decrement();
            HttpServerListener.this.processedRequests.increment();
        }

        @Override
        protected void onResponseContentWriteSuccess(long duration, TimeUnit timeUnit) {
        }

        @Override
        protected void onResponseHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
        }

        @Override
        protected void onResponseContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        @Override
        protected void onResponseHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        @Override
        protected void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        }

        @Override
        protected void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.requestBacklog.decrement();
        }

        @Override
        protected void onNewRequestReceived() {
            HttpServerListener.this.requestBacklog.increment();
            HttpServerListener.this.inflightRequests.increment();
        }

        @Override
        protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingSuccess(duration, timeUnit);
        }

        @Override
        protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingStart(duration, timeUnit);
        }

        @Override
        protected void onNewClientConnected() {
            HttpServerListener.this.onNewClientConnected();
        }

        @Override
        protected void onByteRead(long bytesRead) {
            HttpServerListener.this.onByteRead(bytesRead);
        }

        @Override
        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onFlushSuccess(duration, timeUnit);
        }

        @Override
        protected void onFlushStart() {
            HttpServerListener.this.onFlushStart();
        }

        @Override
        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpServerListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        @Override
        protected void onWriteStart() {
            HttpServerListener.this.onWriteStart();
        }
    }
}

