/*
 * Decompiled with CFR 0.152.
 */
package com.mantisrx.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonUtility {
    private static final JsonUtility INSTANCE = new JsonUtility();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectWriter objectWriter = this.objectMapper.writerFor(Map.class);
    private final ObjectWriter listWriter = this.objectMapper.writerFor(List.class);

    private JsonUtility() {
    }

    public static Map<String, Object> jsonToMap(String jsonString) {
        return INSTANCE._jsonToMap(jsonString);
    }

    public static String mapToJson(Map<String, ? extends Object> map2) {
        return INSTANCE._mapToJson(map2);
    }

    public static List<Object> jsonToList(String jsonString) {
        return INSTANCE._jsonToList(jsonString);
    }

    public static String listToJson(List<? extends Object> list) {
        return INSTANCE._listToJson(list);
    }

    private Map<String, Object> _jsonToMap(String jsonString) {
        try {
            return this.objectMapper.readValue(jsonString, new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to parse JSON", e2);
        }
    }

    private List<Object> _jsonToList(String jsonString) {
        try {
            return this.objectMapper.readValue(jsonString, new TypeReference<List<Object>>(){});
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to parse JSON", e2);
        }
    }

    private String _mapToJson(Map<String, ? extends Object> map2) {
        try {
            return this.objectWriter.writeValueAsString(map2);
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to write JSON", e2);
        }
    }

    private String _listToJson(List<? extends Object> list) {
        try {
            return this.listWriter.writeValueAsString(list);
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to write JSON", e2);
        }
    }
}

