/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ObjectArrays;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final float LOAD_FACTOR = 1.0f;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    private static final long HASH_MASK = -4294967296L;
    @VisibleForTesting
    static final int DEFAULT_SIZE = 3;
    static final int UNSET = -1;
    private transient int @MonotonicNonNull [] table;
    private transient long @MonotonicNonNull [] entries;
    transient Object @MonotonicNonNull [] elements;
    transient int modCount;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        CompactHashSet<E> set2 = CompactHashSet.createWithExpectedSize(collection.size());
        set2.addAll(collection);
        return set2;
    }

    public static <E> CompactHashSet<E> create(E ... elements) {
        CompactHashSet<E> set2 = CompactHashSet.createWithExpectedSize(elements.length);
        Collections.addAll(set2, elements);
        return set2;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int expectedSize) {
        return new CompactHashSet<E>(expectedSize);
    }

    CompactHashSet() {
        this.init(3);
    }

    CompactHashSet(int expectedSize) {
        this.init(expectedSize);
    }

    void init(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "Initial capacity must be non-negative");
        this.modCount = Math.max(1, expectedSize);
    }

    boolean needsAllocArrays() {
        return this.table == null;
    }

    void allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int expectedSize = this.modCount;
        int buckets = Hashing.closedTableSize(expectedSize, 1.0);
        this.table = CompactHashSet.newTable(buckets);
        this.entries = CompactHashSet.newEntries(expectedSize);
        this.elements = new Object[expectedSize];
    }

    private static int[] newTable(int size) {
        int[] array2 = new int[size];
        Arrays.fill(array2, -1);
        return array2;
    }

    private static long[] newEntries(int size) {
        long[] array2 = new long[size];
        Arrays.fill(array2, -1L);
        return array2;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static int getHash(long entry) {
        return (int)(entry >>> 32);
    }

    private static int getNext(long entry) {
        return (int)entry;
    }

    private static long swapNext(long entry, int newNext) {
        return 0xFFFFFFFF00000000L & entry | 0xFFFFFFFFL & (long)newNext;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(@Nullable E object) {
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        long[] entries = this.entries;
        Object[] elements = this.elements;
        int hash2 = Hashing.smearedHash(object);
        int tableIndex = hash2 & this.hashTableMask();
        int newEntryIndex = this.size;
        int next2 = this.table[tableIndex];
        if (next2 == -1) {
            this.table[tableIndex] = newEntryIndex;
        } else {
            long entry;
            do {
                int last2 = next2;
                entry = entries[next2];
                if (CompactHashSet.getHash(entry) != hash2 || !Objects.equal(object, elements[next2])) continue;
                return false;
            } while ((next2 = CompactHashSet.getNext(entry)) != -1);
            entries[last2] = CompactHashSet.swapNext(entry, newEntryIndex);
        }
        if (newEntryIndex == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        int newSize = newEntryIndex + 1;
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, object, hash2);
        this.size = newSize;
        int oldCapacity = this.table.length;
        if (Hashing.needsResizing(newEntryIndex, oldCapacity, 1.0)) {
            this.resizeTable(2 * oldCapacity);
        }
        ++this.modCount;
        return true;
    }

    void insertEntry(int entryIndex, E object, int hash2) {
        this.entries[entryIndex] = (long)hash2 << 32 | 0xFFFFFFFFL;
        this.elements[entryIndex] = object;
    }

    private void resizeMeMaybe(int newSize) {
        int entriesSize = this.entries.length;
        if (newSize > entriesSize) {
            int newCapacity = entriesSize + Math.max(1, entriesSize >>> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            if (newCapacity != entriesSize) {
                this.resizeEntries(newCapacity);
            }
        }
    }

    void resizeEntries(int newCapacity) {
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        long[] entries = this.entries;
        int oldCapacity = entries.length;
        entries = Arrays.copyOf(entries, newCapacity);
        if (newCapacity > oldCapacity) {
            Arrays.fill(entries, oldCapacity, newCapacity, -1L);
        }
        this.entries = entries;
    }

    private void resizeTable(int newCapacity) {
        int[] newTable = CompactHashSet.newTable(newCapacity);
        long[] entries = this.entries;
        int mask = newTable.length - 1;
        for (int i = 0; i < this.size; ++i) {
            long oldEntry = entries[i];
            int hash2 = CompactHashSet.getHash(oldEntry);
            int tableIndex = hash2 & mask;
            int next2 = newTable[tableIndex];
            newTable[tableIndex] = i;
            entries[i] = (long)hash2 << 32 | 0xFFFFFFFFL & (long)next2;
        }
        this.table = newTable;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        int hash2 = Hashing.smearedHash(object);
        int next2 = this.table[hash2 & this.hashTableMask()];
        while (next2 != -1) {
            long entry = this.entries[next2];
            if (CompactHashSet.getHash(entry) == hash2 && Objects.equal(object, this.elements[next2])) {
                return true;
            }
            next2 = CompactHashSet.getNext(entry);
        }
        return false;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        return this.remove(object, Hashing.smearedHash(object));
    }

    @CanIgnoreReturnValue
    private boolean remove(Object object, int hash2) {
        int tableIndex = hash2 & this.hashTableMask();
        int next2 = this.table[tableIndex];
        if (next2 == -1) {
            return false;
        }
        int last2 = -1;
        do {
            if (CompactHashSet.getHash(this.entries[next2]) == hash2 && Objects.equal(object, this.elements[next2])) {
                if (last2 == -1) {
                    this.table[tableIndex] = CompactHashSet.getNext(this.entries[next2]);
                } else {
                    this.entries[last2] = CompactHashSet.swapNext(this.entries[last2], CompactHashSet.getNext(this.entries[next2]));
                }
                this.moveLastEntry(next2);
                --this.size;
                ++this.modCount;
                return true;
            }
            last2 = next2;
        } while ((next2 = CompactHashSet.getNext(this.entries[next2])) != -1);
        return false;
    }

    void moveLastEntry(int dstIndex) {
        int srcIndex = this.size() - 1;
        if (dstIndex < srcIndex) {
            long lastEntry;
            this.elements[dstIndex] = this.elements[srcIndex];
            this.elements[srcIndex] = null;
            this.entries[dstIndex] = lastEntry = this.entries[srcIndex];
            this.entries[srcIndex] = -1L;
            int tableIndex = CompactHashSet.getHash(lastEntry) & this.hashTableMask();
            int lastNext = this.table[tableIndex];
            if (lastNext == srcIndex) {
                this.table[tableIndex] = dstIndex;
            } else {
                long entry;
                do {
                    int previous = lastNext;
                } while ((lastNext = CompactHashSet.getNext(entry = this.entries[lastNext])) != srcIndex);
                this.entries[previous] = CompactHashSet.swapNext(entry, dstIndex);
            }
        } else {
            this.elements[dstIndex] = null;
            this.entries[dstIndex] = -1L;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int entryIndex) {
        return entryIndex + 1 < this.size ? entryIndex + 1 : -1;
    }

    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int expectedModCount;
            int currentIndex;
            int indexToRemove;
            {
                this.expectedModCount = CompactHashSet.this.modCount;
                this.currentIndex = CompactHashSet.this.firstEntryIndex();
                this.indexToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex >= 0;
            }

            @Override
            public E next() {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.currentIndex;
                Object result = CompactHashSet.this.elements[this.currentIndex];
                this.currentIndex = CompactHashSet.this.getSuccessor(this.currentIndex);
                return result;
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                CollectPreconditions.checkRemove(this.indexToRemove >= 0);
                ++this.expectedModCount;
                CompactHashSet.this.remove(CompactHashSet.this.elements[this.indexToRemove], CompactHashSet.getHash(CompactHashSet.this.entries[this.indexToRemove]));
                this.currentIndex = CompactHashSet.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
                this.indexToRemove = -1;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.needsAllocArrays()) {
            return Spliterators.spliterator(new Object[0], 17);
        }
        return Spliterators.spliterator(this.elements, 0, this.size, 17);
    }

    @Override
    public void forEach(Consumer<? super E> action2) {
        Preconditions.checkNotNull(action2);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            action2.accept(this.elements[i]);
            i = this.getSuccessor(i);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        if (this.needsAllocArrays()) {
            return new Object[0];
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> T[] toArray(T[] a) {
        if (this.needsAllocArrays()) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        return ObjectArrays.toArrayImpl(this.elements, 0, this.size, a);
    }

    public void trimToSize() {
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        int size = this.size;
        if (size < this.entries.length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = Hashing.closedTableSize(size, 1.0)) < this.table.length) {
            this.resizeTable(minimumTableSize);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        ++this.modCount;
        Arrays.fill(this.elements, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, 0, this.size, -1L);
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            stream.writeObject(this.elements[i]);
            i = this.getSuccessor(i);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException("Invalid size: " + elementCount);
        }
        this.init(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Object element = stream.readObject();
            this.add(element);
        }
    }
}

