/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public class StringMethodPropertyWriter
extends OptimizedBeanPropertyWriter<StringMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;

    public StringMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index2, JsonSerializer<Object> ser) {
        super(src, acc, index2, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringGetter(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, false);
            return;
        }
        if (value == null) {
            if (this._nullSerializer != null) {
                gen.writeFieldName(this._fastName);
                this._nullSerializer.serialize(null, gen, prov);
            } else if (!this._suppressNulls) {
                gen.writeFieldName(this._fastName);
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
            return;
        }
        gen.writeFieldName(this._fastName);
        gen.writeString(value);
    }

    @Override
    public final void serializeAsElement(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringGetter(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, true);
            return;
        }
        if (value == null) {
            if (this._suppressNulls) {
                this.serializeAsPlaceholder(bean2, gen, prov);
            } else {
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (value.length() == 0) {
                    this.serializeAsPlaceholder(bean2, gen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean2, gen, prov);
                return;
            }
        }
        gen.writeString(value);
    }
}

