/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.metrics;

import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.ClientMetricEventsListener;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientMetricsEvent;

public abstract class HttpClientMetricEventsListener
extends ClientMetricEventsListener<ClientMetricsEvent<?>> {
    @Override
    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType() instanceof ClientMetricsEvent.EventType) {
            super.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            switch ((HttpClientMetricsEvent.EventType)event.getType()) {
                case RequestSubmitted: {
                    this.onRequestSubmitted();
                    break;
                }
                case RequestContentSourceError: {
                    this.onRequestContentSourceError(throwable);
                    break;
                }
                case RequestHeadersWriteStart: {
                    this.onRequestHeadersWriteStart();
                    break;
                }
                case RequestHeadersWriteSuccess: {
                    this.onRequestHeadersWriteSuccess(duration, timeUnit);
                    break;
                }
                case RequestHeadersWriteFailed: {
                    this.onRequestHeadersWriteFailed(duration, timeUnit, throwable);
                    break;
                }
                case RequestContentWriteStart: {
                    this.onRequestContentWriteStart();
                    break;
                }
                case RequestContentWriteSuccess: {
                    this.onRequestContentWriteSuccess(duration, timeUnit);
                    break;
                }
                case RequestContentWriteFailed: {
                    this.onRequestContentWriteFailed(duration, timeUnit, throwable);
                    break;
                }
                case RequestWriteComplete: {
                    this.onRequestWriteComplete(duration, timeUnit);
                    break;
                }
                case RequestWriteFailed: {
                    this.onRequestWriteFailed(duration, timeUnit, throwable);
                    break;
                }
                case ResponseHeadersReceived: {
                    this.onResponseHeadersReceived(duration, timeUnit);
                    break;
                }
                case ResponseContentReceived: {
                    this.onResponseContentReceived(duration, timeUnit);
                    break;
                }
                case ResponseReceiveComplete: {
                    this.onResponseReceiveComplete(duration, timeUnit);
                    break;
                }
                case ResponseFailed: {
                    this.onResponseFailed(duration, timeUnit, throwable);
                    break;
                }
                case RequestProcessingComplete: {
                    this.onRequestProcessingComplete(duration, timeUnit);
                }
            }
        }
    }

    protected void onRequestContentSourceError(Throwable throwable) {
    }

    protected void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onResponseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
    }

    protected void onResponseContentReceived(long duration, TimeUnit timeUnit) {
    }

    protected void onResponseHeadersReceived(long duration, TimeUnit timeUnit) {
    }

    protected void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
    }

    protected void onRequestContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onRequestContentWriteSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onRequestContentWriteStart() {
    }

    protected void onRequestHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onRequestHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onRequestHeadersWriteStart() {
    }

    protected void onRequestSubmitted() {
    }

    protected void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
    }
}

