/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.reactivex.mantis.network.push.RemoteRxEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyTcpPipelineConfigurator
implements PipelineConfigurator<RemoteRxEvent, List<RemoteRxEvent>> {
    private static final Logger logger = LoggerFactory.getLogger(LegacyTcpPipelineConfigurator.class);
    private static final byte PROTOCOL_VERSION = 1;
    private String name;

    public LegacyTcpPipelineConfigurator(String name2) {
        this.name = name2;
    }

    static Map<String, String> fromBytesToMap(byte[] bytes2) {
        Map map2 = null;
        ByteArrayInputStream bis = null;
        ObjectInput in = null;
        try {
            bis = new ByteArrayInputStream(bytes2);
            in = new ObjectInputStream(bis);
            map2 = (Map)in.readObject();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        return map2;
    }

    static byte[] fromMapToBytes(Map<String, String> map2) {
        ByteArrayOutputStream baos = null;
        ObjectOutput out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(map2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelDuplexHandler(){

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ByteBuf byteBuf;
                boolean handled = false;
                if (ByteBuf.class.isAssignableFrom(msg.getClass()) && (byteBuf = (ByteBuf)msg).isReadable()) {
                    byte protocolVersion = byteBuf.readByte();
                    if (protocolVersion != 1) {
                        throw new RuntimeException("Unsupported protocol version: " + protocolVersion);
                    }
                    byte observableNameLength = byteBuf.readByte();
                    String observableName = null;
                    if (observableNameLength > 0) {
                        byte[] observableNameBytes = new byte[observableNameLength];
                        byteBuf.readBytes(observableNameBytes);
                        observableName = new String(observableNameBytes, Charset.forName("UTF-8"));
                    }
                    while (byteBuf.isReadable()) {
                        int lengthOfEvent = byteBuf.readInt();
                        byte operation = byteBuf.readByte();
                        RemoteRxEvent.Type type2 = null;
                        Map<String, String> subscribeParams = null;
                        byte[] valueData = null;
                        if (operation == 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: next");
                            }
                            type2 = RemoteRxEvent.Type.next;
                            valueData = new byte[lengthOfEvent - 1];
                            byteBuf.readBytes(valueData);
                        } else if (operation == 2) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: error");
                            }
                            type2 = RemoteRxEvent.Type.error;
                            valueData = new byte[lengthOfEvent - 1];
                            byteBuf.readBytes(valueData);
                        } else if (operation == 3) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: completed");
                            }
                            type2 = RemoteRxEvent.Type.completed;
                        } else if (operation == 4) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: subscribed");
                            }
                            type2 = RemoteRxEvent.Type.subscribed;
                            int subscribeParamsLength = byteBuf.readInt();
                            if (subscribeParamsLength > 0) {
                                byte[] subscribeParamsBytes = new byte[subscribeParamsLength];
                                byteBuf.readBytes(subscribeParamsBytes);
                                subscribeParams = LegacyTcpPipelineConfigurator.fromBytesToMap(subscribeParamsBytes);
                            }
                        } else if (operation == 5) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: unsubscribed");
                            }
                            type2 = RemoteRxEvent.Type.unsubscribed;
                        } else if (operation == 6) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: heartbeat");
                            }
                        } else if (operation == 7) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("READ request for RemoteRxEvent: nonDataError");
                            }
                            type2 = RemoteRxEvent.Type.nonDataError;
                            valueData = new byte[lengthOfEvent - 1];
                            byteBuf.readBytes(valueData);
                        } else {
                            throw new RuntimeException("operation: " + operation + " not support.");
                        }
                        if (operation == 6) continue;
                        ctx.fireChannelRead(new RemoteRxEvent(observableName, type2, valueData, subscribeParams));
                    }
                    handled = true;
                    byteBuf.release();
                }
                if (!handled) {
                    super.channelRead(ctx, msg);
                }
            }
        });
        pipeline.addLast(new ChannelDuplexHandler(){

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
                if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                    ByteBuf bytes2 = (ByteBuf)msg;
                    ByteBuf buf = ctx.alloc().buffer(bytes2.readableBytes());
                    LegacyTcpPipelineConfigurator.this.writeHeader(buf, LegacyTcpPipelineConfigurator.this.name);
                    buf.writeBytes(bytes2);
                    bytes2.release();
                    super.write(ctx, buf, promise2);
                } else if (msg instanceof byte[]) {
                    ByteBuf buf = ctx.alloc().buffer();
                    LegacyTcpPipelineConfigurator.this.writeHeader(buf, LegacyTcpPipelineConfigurator.this.name);
                    buf.writeBytes((byte[])msg);
                    super.write(ctx, buf, promise2);
                    super.flush(ctx);
                } else {
                    super.write(ctx, msg, promise2);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeHeader(ByteBuf buf, String name2) {
        buf.writeByte(1);
        String observableName = name2;
        if (observableName != null && !observableName.isEmpty()) {
            int nameLength = observableName.length();
            if (nameLength >= 127) throw new RuntimeException("observableName " + observableName + " exceeds max limit of 127 characters");
            buf.writeByte(nameLength);
            buf.writeBytes(observableName.getBytes());
            return;
        } else {
            buf.writeByte(0);
        }
    }
}

