/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer.config;

import io.mantisrx.connector.iceberg.sink.config.SinkConfig;
import io.mantisrx.connector.iceberg.sink.writer.config.WriterProperties;
import io.mantisrx.runtime.parameter.Parameters;
import org.apache.hadoop.conf.Configuration;

public class WriterConfig
extends SinkConfig {
    private final int writerRowGroupSize;
    private final long writerFlushFrequencyBytes;
    private final long writerFlushFrequencyMsec;
    private final String writerFileFormat;
    private final Configuration hadoopConfig;

    public WriterConfig(Parameters parameters, Configuration hadoopConfig) {
        super(parameters);
        this.writerRowGroupSize = (Integer)parameters.get("writerRowGroupSize", 1000);
        this.writerFlushFrequencyBytes = Long.parseLong((String)parameters.get("writerFlushFrequencyBytes", "134217728"));
        this.writerFlushFrequencyMsec = Long.parseLong((String)parameters.get("writerFlushFrequencyMsec", "60000"));
        this.writerFileFormat = (String)parameters.get("writerFileFormat", WriterProperties.WRITER_FILE_FORMAT_DEFAULT);
        this.hadoopConfig = hadoopConfig;
    }

    public int getWriterRowGroupSize() {
        return this.writerRowGroupSize;
    }

    public long getWriterFlushFrequencyBytes() {
        return this.writerFlushFrequencyBytes;
    }

    public long getWriterFlushFrequencyMsec() {
        return this.writerFlushFrequencyMsec;
    }

    public String getWriterFileFormat() {
        return this.writerFileFormat;
    }

    public Configuration getHadoopConfig() {
        return this.hadoopConfig;
    }
}

