/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.internal.operators.BackpressureUtils;
import rx.plugins.RxJavaHooks;
import rx.schedulers.Schedulers;
import rx.subjects.Subject;

public final class ReplaySubject<T>
extends Subject<T, T> {
    final ReplayState<T> state;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity > 0 required but it was " + capacity);
        }
        ReplayUnboundedBuffer buffer = new ReplayUnboundedBuffer(capacity);
        ReplayState state = new ReplayState(buffer);
        return new ReplaySubject(state);
    }

    static <T> ReplaySubject<T> createUnbounded() {
        ReplaySizeBoundBuffer buffer = new ReplaySizeBoundBuffer(Integer.MAX_VALUE);
        ReplayState state = new ReplayState(buffer);
        return new ReplaySubject(state);
    }

    static <T> ReplaySubject<T> createUnboundedTime() {
        ReplaySizeAndTimeBoundBuffer buffer = new ReplaySizeAndTimeBoundBuffer(Integer.MAX_VALUE, Long.MAX_VALUE, Schedulers.immediate());
        ReplayState state = new ReplayState(buffer);
        return new ReplaySubject(state);
    }

    public static <T> ReplaySubject<T> createWithSize(int size) {
        ReplaySizeBoundBuffer buffer = new ReplaySizeBoundBuffer(size);
        ReplayState state = new ReplayState(buffer);
        return new ReplaySubject(state);
    }

    public static <T> ReplaySubject<T> createWithTime(long time2, TimeUnit unit, Scheduler scheduler) {
        return ReplaySubject.createWithTimeAndSize(time2, unit, Integer.MAX_VALUE, scheduler);
    }

    public static <T> ReplaySubject<T> createWithTimeAndSize(long time2, TimeUnit unit, int size, Scheduler scheduler) {
        ReplaySizeAndTimeBoundBuffer buffer = new ReplaySizeAndTimeBoundBuffer(size, unit.toMillis(time2), scheduler);
        ReplayState state = new ReplayState(buffer);
        return new ReplaySubject(state);
    }

    ReplaySubject(ReplayState<T> state) {
        super(state);
        this.state = state;
    }

    @Override
    public void onNext(T t) {
        this.state.onNext(t);
    }

    @Override
    public void onError(Throwable e2) {
        this.state.onError(e2);
    }

    @Override
    public void onCompleted() {
        this.state.onCompleted();
    }

    int subscriberCount() {
        return ((ReplayProducer[])this.state.get()).length;
    }

    @Override
    public boolean hasObservers() {
        return ((ReplayProducer[])this.state.get()).length != 0;
    }

    public boolean hasThrowable() {
        return this.state.isTerminated() && this.state.buffer.error() != null;
    }

    public boolean hasCompleted() {
        return this.state.isTerminated() && this.state.buffer.error() == null;
    }

    public Throwable getThrowable() {
        if (this.state.isTerminated()) {
            return this.state.buffer.error();
        }
        return null;
    }

    public int size() {
        return this.state.buffer.size();
    }

    public boolean hasAnyValue() {
        return !this.state.buffer.isEmpty();
    }

    public boolean hasValue() {
        return this.hasAnyValue();
    }

    public T[] getValues(T[] a) {
        return this.state.buffer.toArray(a);
    }

    public Object[] getValues() {
        Object[] r = this.getValues(EMPTY_ARRAY);
        if (r == EMPTY_ARRAY) {
            return new Object[0];
        }
        return r;
    }

    public T getValue() {
        return this.state.buffer.last();
    }

    static final class ReplayProducer<T>
    extends AtomicInteger
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -5006209596735204567L;
        final Subscriber<? super T> actual;
        final AtomicLong requested;
        final ReplayState<T> state;
        int index;
        int tailIndex;
        Object node;

        public ReplayProducer(Subscriber<? super T> actual, ReplayState<T> state) {
            this.actual = actual;
            this.requested = new AtomicLong();
            this.state = state;
        }

        @Override
        public void unsubscribe() {
            this.state.remove(this);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.actual.isUnsubscribed();
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                this.state.buffer.drain(this);
            } else if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
        }
    }

    static final class ReplaySizeAndTimeBoundBuffer<T>
    implements ReplayBuffer<T> {
        final int limit;
        final long maxAgeMillis;
        final Scheduler scheduler;
        volatile TimedNode<T> head;
        TimedNode<T> tail;
        int size;
        volatile boolean done;
        Throwable error;

        public ReplaySizeAndTimeBoundBuffer(int limit2, long maxAgeMillis, Scheduler scheduler) {
            this.limit = limit2;
            TimedNode<Object> n = new TimedNode<Object>(null, 0L);
            this.tail = n;
            this.head = n;
            this.maxAgeMillis = maxAgeMillis;
            this.scheduler = scheduler;
        }

        @Override
        public void next(T value) {
            TimedNode h0;
            long now = this.scheduler.now();
            TimedNode n = new TimedNode(value, now);
            this.tail.set(n);
            this.tail = n;
            now -= this.maxAgeMillis;
            int s2 = this.size;
            TimedNode h2 = h0 = this.head;
            if (s2 == this.limit) {
                h2 = (TimedNode)h2.get();
            } else {
                ++s2;
            }
            while ((n = (TimedNode)h2.get()) != null && n.timestamp <= now) {
                h2 = n;
                --s2;
            }
            this.size = s2;
            if (h2 != h0) {
                this.head = h2;
            }
        }

        @Override
        public void error(Throwable ex) {
            this.evictFinal();
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.evictFinal();
            this.done = true;
        }

        void evictFinal() {
            TimedNode n;
            TimedNode h0;
            long now = this.scheduler.now() - this.maxAgeMillis;
            TimedNode h2 = h0 = this.head;
            while ((n = (TimedNode)h2.get()) != null && n.timestamp <= now) {
                h2 = n;
            }
            if (h0 != h2) {
                this.head = h2;
            }
        }

        TimedNode<T> latestHead() {
            TimedNode n;
            long now = this.scheduler.now() - this.maxAgeMillis;
            TimedNode h2 = this.head;
            while ((n = (TimedNode)h2.get()) != null && n.timestamp <= now) {
                h2 = n;
            }
            return h2;
        }

        @Override
        public void drain(ReplayProducer<T> rp) {
            if (rp.getAndIncrement() != 0) {
                return;
            }
            Subscriber a = rp.actual;
            int missed = 1;
            do {
                boolean d;
                long r = rp.requested.get();
                long e2 = 0L;
                TimedNode node2 = (TimedNode)rp.node;
                if (node2 == null) {
                    node2 = this.latestHead();
                }
                while (e2 != r) {
                    boolean empty2;
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    TimedNode next2 = (TimedNode)node2.get();
                    boolean bl = empty2 = next2 == null;
                    if (d && empty2) {
                        rp.node = null;
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                    if (empty2) break;
                    a.onNext(next2.value);
                    ++e2;
                    node2 = next2;
                }
                if (e2 == r) {
                    boolean empty3;
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    boolean bl = empty3 = node2.get() == null;
                    if (d && empty3) {
                        rp.node = null;
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                }
                if (e2 != 0L && r != Long.MAX_VALUE) {
                    BackpressureUtils.produced(rp.requested, e2);
                }
                rp.node = node2;
            } while ((missed = rp.addAndGet(-missed)) != 0);
        }

        @Override
        public boolean isComplete() {
            return this.done;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public T last() {
            TimedNode n;
            TimedNode h2 = this.latestHead();
            while ((n = (TimedNode)h2.get()) != null) {
                h2 = n;
            }
            return h2.value;
        }

        @Override
        public int size() {
            int s2 = 0;
            for (TimedNode n = (TimedNode)this.latestHead().get(); n != null && s2 != Integer.MAX_VALUE; n = (TimedNode)n.get(), ++s2) {
            }
            return s2;
        }

        @Override
        public boolean isEmpty() {
            return this.latestHead().get() == null;
        }

        @Override
        public T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            for (TimedNode n = (TimedNode)this.latestHead().get(); n != null; n = (TimedNode)n.get()) {
                list.add(n.value);
            }
            return list.toArray(a);
        }

        static final class TimedNode<T>
        extends AtomicReference<TimedNode<T>> {
            private static final long serialVersionUID = 3713592843205853725L;
            final T value;
            final long timestamp;

            public TimedNode(T value, long timestamp) {
                this.value = value;
                this.timestamp = timestamp;
            }
        }
    }

    static final class ReplaySizeBoundBuffer<T>
    implements ReplayBuffer<T> {
        final int limit;
        volatile Node<T> head;
        Node<T> tail;
        int size;
        volatile boolean done;
        Throwable error;

        public ReplaySizeBoundBuffer(int limit2) {
            this.limit = limit2;
            Node<Object> n = new Node<Object>(null);
            this.tail = n;
            this.head = n;
        }

        @Override
        public void next(T value) {
            Node<T> n = new Node<T>(value);
            this.tail.set(n);
            this.tail = n;
            int s2 = this.size;
            if (s2 == this.limit) {
                this.head = (Node)this.head.get();
            } else {
                this.size = s2 + 1;
            }
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void drain(ReplayProducer<T> rp) {
            if (rp.getAndIncrement() != 0) {
                return;
            }
            Subscriber a = rp.actual;
            int missed = 1;
            do {
                boolean d;
                long r = rp.requested.get();
                long e2 = 0L;
                Node node2 = (Node)rp.node;
                if (node2 == null) {
                    node2 = this.head;
                }
                while (e2 != r) {
                    boolean empty2;
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    Node next2 = (Node)node2.get();
                    boolean bl = empty2 = next2 == null;
                    if (d && empty2) {
                        rp.node = null;
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                    if (empty2) break;
                    a.onNext(next2.value);
                    ++e2;
                    node2 = next2;
                }
                if (e2 == r) {
                    boolean empty3;
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    boolean bl = empty3 = node2.get() == null;
                    if (d && empty3) {
                        rp.node = null;
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                }
                if (e2 != 0L && r != Long.MAX_VALUE) {
                    BackpressureUtils.produced(rp.requested, e2);
                }
                rp.node = node2;
            } while ((missed = rp.addAndGet(-missed)) != 0);
        }

        @Override
        public boolean isComplete() {
            return this.done;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public T last() {
            Node n;
            Node h2 = this.head;
            while ((n = (Node)h2.get()) != null) {
                h2 = n;
            }
            return h2.value;
        }

        @Override
        public int size() {
            int s2 = 0;
            for (Node n = (Node)this.head.get(); n != null && s2 != Integer.MAX_VALUE; n = (Node)n.get(), ++s2) {
            }
            return s2;
        }

        @Override
        public boolean isEmpty() {
            return this.head.get() == null;
        }

        @Override
        public T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            for (Node n = (Node)this.head.get(); n != null; n = (Node)n.get()) {
                list.add(n.value);
            }
            return list.toArray(a);
        }

        static final class Node<T>
        extends AtomicReference<Node<T>> {
            private static final long serialVersionUID = 3713592843205853725L;
            final T value;

            public Node(T value) {
                this.value = value;
            }
        }
    }

    static final class ReplayUnboundedBuffer<T>
    implements ReplayBuffer<T> {
        final int capacity;
        volatile int size;
        final Object[] head;
        Object[] tail;
        int tailIndex;
        volatile boolean done;
        Throwable error;

        public ReplayUnboundedBuffer(int capacity) {
            this.capacity = capacity;
            this.head = new Object[capacity + 1];
            this.tail = this.head;
        }

        @Override
        public void next(T t) {
            if (this.done) {
                return;
            }
            int i = this.tailIndex;
            Object[] a = this.tail;
            if (i == a.length - 1) {
                Object[] b = new Object[a.length];
                b[0] = t;
                this.tailIndex = 1;
                a[i] = b;
                this.tail = b;
            } else {
                a[i] = t;
                this.tailIndex = i + 1;
            }
            ++this.size;
        }

        @Override
        public void error(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.error = e2;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void drain(ReplayProducer<T> rp) {
            if (rp.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Object> a = rp.actual;
            int n = this.capacity;
            do {
                Throwable ex;
                boolean empty2;
                boolean d;
                long r = rp.requested.get();
                long e2 = 0L;
                Object[] node2 = (Object[])rp.node;
                if (node2 == null) {
                    node2 = this.head;
                }
                int tailIndex = rp.tailIndex;
                int index2 = rp.index;
                while (e2 != r) {
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    boolean bl = empty2 = index2 == this.size;
                    if (d && empty2) {
                        rp.node = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                    if (empty2) break;
                    if (tailIndex == n) {
                        node2 = (Object[])node2[tailIndex];
                        tailIndex = 0;
                    }
                    Object v = node2[tailIndex];
                    a.onNext(v);
                    ++e2;
                    ++tailIndex;
                    ++index2;
                }
                if (e2 == r) {
                    if (a.isUnsubscribed()) {
                        rp.node = null;
                        return;
                    }
                    d = this.done;
                    boolean bl = empty2 = index2 == this.size;
                    if (d && empty2) {
                        rp.node = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                }
                if (e2 != 0L && r != Long.MAX_VALUE) {
                    BackpressureUtils.produced(rp.requested, e2);
                }
                rp.index = index2;
                rp.tailIndex = tailIndex;
                rp.node = node2;
            } while ((missed = rp.addAndGet(-missed)) != 0);
        }

        @Override
        public boolean isComplete() {
            return this.done;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public T last() {
            int s2 = this.size;
            if (s2 == 0) {
                return null;
            }
            Object[] h2 = this.head;
            int n = this.capacity;
            while (s2 >= n) {
                h2 = (Object[])h2[n];
                s2 -= n;
            }
            return (T)h2[s2 - 1];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public T[] toArray(T[] a) {
            int s2 = this.size;
            if (a.length < s2) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), s2);
            }
            Object[] h2 = this.head;
            int n = this.capacity;
            int j = 0;
            while (j + n < s2) {
                System.arraycopy(h2, 0, a, j, n);
                j += n;
                h2 = (Object[])h2[n];
            }
            System.arraycopy(h2, 0, a, j, s2 - j);
            if (a.length > s2) {
                a[s2] = null;
            }
            return a;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void drain(ReplayProducer<T> var1);

        public boolean isComplete();

        public Throwable error();

        public T last();

        public int size();

        public boolean isEmpty();

        public T[] toArray(T[] var1);
    }

    static final class ReplayState<T>
    extends AtomicReference<ReplayProducer<T>[]>
    implements Observable.OnSubscribe<T>,
    Observer<T> {
        private static final long serialVersionUID = 5952362471246910544L;
        final ReplayBuffer<T> buffer;
        static final ReplayProducer[] EMPTY = new ReplayProducer[0];
        static final ReplayProducer[] TERMINATED = new ReplayProducer[0];

        public ReplayState(ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.lazySet(EMPTY);
        }

        @Override
        public void call(Subscriber<? super T> t) {
            ReplayProducer<T> rp = new ReplayProducer<T>(t, this);
            t.add(rp);
            t.setProducer(rp);
            if (this.add(rp) && rp.isUnsubscribed()) {
                this.remove(rp);
                return;
            }
            this.buffer.drain(rp);
        }

        boolean add(ReplayProducer<T> rp) {
            ReplayProducer[] b;
            ReplayProducer[] a;
            do {
                if ((a = (ReplayProducer[])this.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new ReplayProducer[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = rp;
            } while (!this.compareAndSet(a, b));
            return true;
        }

        void remove(ReplayProducer<T> rp) {
            ReplayProducer[] b;
            ReplayProducer[] a;
            do {
                if ((a = (ReplayProducer[])this.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != rp) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new ReplayProducer[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.compareAndSet(a, b));
        }

        @Override
        public void onNext(T t) {
            ReplayBuffer<T> b = this.buffer;
            b.next(t);
            for (ReplayProducer rp : (ReplayProducer[])this.get()) {
                b.drain(rp);
            }
        }

        @Override
        public void onError(Throwable e2) {
            ReplayBuffer<T> b = this.buffer;
            b.error(e2);
            ArrayList<Throwable> errors = null;
            for (ReplayProducer rp : this.getAndSet(TERMINATED)) {
                try {
                    b.drain(rp);
                }
                catch (Throwable ex) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(ex);
                }
            }
            Exceptions.throwIfAny(errors);
        }

        @Override
        public void onCompleted() {
            ReplayBuffer<T> b = this.buffer;
            b.complete();
            for (ReplayProducer rp : this.getAndSet(TERMINATED)) {
                b.drain(rp);
            }
        }

        boolean isTerminated() {
            return this.get() == TERMINATED;
        }
    }
}

