/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.CompletableEmitter;
import rx.CompletableSubscriber;
import rx.Notification;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.internal.observers.AssertableSubscriberObservable;
import rx.internal.operators.CompletableFromEmitter;
import rx.internal.operators.CompletableOnSubscribeConcat;
import rx.internal.operators.CompletableOnSubscribeConcatArray;
import rx.internal.operators.CompletableOnSubscribeConcatIterable;
import rx.internal.operators.CompletableOnSubscribeMerge;
import rx.internal.operators.CompletableOnSubscribeMergeArray;
import rx.internal.operators.CompletableOnSubscribeMergeDelayErrorArray;
import rx.internal.operators.CompletableOnSubscribeMergeDelayErrorIterable;
import rx.internal.operators.CompletableOnSubscribeMergeIterable;
import rx.internal.operators.CompletableOnSubscribeTimeout;
import rx.internal.util.SubscriptionList;
import rx.internal.util.UtilityFunctions;
import rx.observers.AssertableSubscriber;
import rx.observers.SafeCompletableSubscriber;
import rx.observers.SafeSubscriber;
import rx.plugins.RxJavaHooks;
import rx.schedulers.Schedulers;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public class Completable {
    private final OnSubscribe onSubscribe;
    static final Completable COMPLETE = new Completable(new OnSubscribe(){

        @Override
        public void call(CompletableSubscriber s2) {
            s2.onSubscribe(Subscriptions.unsubscribed());
            s2.onCompleted();
        }
    }, false);
    static final Completable NEVER = new Completable(new OnSubscribe(){

        @Override
        public void call(CompletableSubscriber s2) {
            s2.onSubscribe(Subscriptions.unsubscribed());
        }
    }, false);

    public static Completable amb(final Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                final CompositeSubscription set2 = new CompositeSubscription();
                s2.onSubscribe(set2);
                final AtomicBoolean once = new AtomicBoolean();
                CompletableSubscriber inner = new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onCompleted();
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(e2);
                        } else {
                            RxJavaHooks.onError(e2);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set2.add(d);
                    }
                };
                for (Completable c : sources) {
                    if (set2.isUnsubscribed()) {
                        return;
                    }
                    if (c == null) {
                        NullPointerException npe = new NullPointerException("One of the sources is null");
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(npe);
                        } else {
                            RxJavaHooks.onError(npe);
                        }
                        return;
                    }
                    if (once.get() || set2.isUnsubscribed()) {
                        return;
                    }
                    c.unsafeSubscribe(inner);
                }
            }
        });
    }

    public static Completable amb(final Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                Iterator it;
                final CompositeSubscription set2 = new CompositeSubscription();
                s2.onSubscribe(set2);
                try {
                    it = sources.iterator();
                }
                catch (Throwable e2) {
                    s2.onError(e2);
                    return;
                }
                if (it == null) {
                    s2.onError(new NullPointerException("The iterator returned is null"));
                    return;
                }
                boolean empty2 = true;
                final AtomicBoolean once = new AtomicBoolean();
                CompletableSubscriber inner = new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onCompleted();
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(e2);
                        } else {
                            RxJavaHooks.onError(e2);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set2.add(d);
                    }
                };
                while (true) {
                    Completable c;
                    boolean b;
                    if (once.get() || set2.isUnsubscribed()) {
                        return;
                    }
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e3) {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(e3);
                        } else {
                            RxJavaHooks.onError(e3);
                        }
                        return;
                    }
                    if (!b) {
                        if (!empty2) break;
                        s2.onCompleted();
                        break;
                    }
                    empty2 = false;
                    if (once.get() || set2.isUnsubscribed()) {
                        return;
                    }
                    try {
                        c = (Completable)it.next();
                    }
                    catch (Throwable e4) {
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(e4);
                        } else {
                            RxJavaHooks.onError(e4);
                        }
                        return;
                    }
                    if (c == null) {
                        NullPointerException npe = new NullPointerException("One of the sources is null");
                        if (once.compareAndSet(false, true)) {
                            set2.unsubscribe();
                            s2.onError(npe);
                        } else {
                            RxJavaHooks.onError(npe);
                        }
                        return;
                    }
                    if (once.get() || set2.isUnsubscribed()) {
                        return;
                    }
                    c.unsafeSubscribe(inner);
                }
            }
        });
    }

    public static Completable complete() {
        OnSubscribe cos = RxJavaHooks.onCreate(Completable.COMPLETE.onSubscribe);
        if (cos == Completable.COMPLETE.onSubscribe) {
            return COMPLETE;
        }
        return new Completable(cos, false);
    }

    public static Completable concat(Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new CompletableOnSubscribeConcatArray(sources));
    }

    public static Completable concat(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeConcatIterable(sources));
    }

    public static Completable concat(Observable<? extends Completable> sources) {
        return Completable.concat(sources, 2);
    }

    public static Completable concat(Observable<? extends Completable> sources, int prefetch) {
        Completable.requireNonNull(sources);
        if (prefetch < 1) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        return Completable.create(new CompletableOnSubscribeConcat(sources, prefetch));
    }

    public static Completable create(OnSubscribe onSubscribe) {
        Completable.requireNonNull(onSubscribe);
        try {
            return new Completable(onSubscribe);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            RxJavaHooks.onError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public static Completable defer(final Func0<? extends Completable> completableFunc0) {
        Completable.requireNonNull(completableFunc0);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                Completable c;
                try {
                    c = (Completable)completableFunc0.call();
                }
                catch (Throwable e2) {
                    s2.onSubscribe(Subscriptions.unsubscribed());
                    s2.onError(e2);
                    return;
                }
                if (c == null) {
                    s2.onSubscribe(Subscriptions.unsubscribed());
                    s2.onError(new NullPointerException("The completable returned is null"));
                    return;
                }
                c.unsafeSubscribe(s2);
            }
        });
    }

    public static Completable error(final Func0<? extends Throwable> errorFunc0) {
        Completable.requireNonNull(errorFunc0);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                Throwable error;
                s2.onSubscribe(Subscriptions.unsubscribed());
                try {
                    error = (Throwable)errorFunc0.call();
                }
                catch (Throwable e2) {
                    error = e2;
                }
                if (error == null) {
                    error = new NullPointerException("The error supplied is null");
                }
                s2.onError(error);
            }
        });
    }

    public static Completable error(final Throwable error) {
        Completable.requireNonNull(error);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                s2.onSubscribe(Subscriptions.unsubscribed());
                s2.onError(error);
            }
        });
    }

    public static Completable fromAction(final Action0 action2) {
        Completable.requireNonNull(action2);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                BooleanSubscription bs = new BooleanSubscription();
                s2.onSubscribe(bs);
                try {
                    action2.call();
                }
                catch (Throwable e2) {
                    if (!bs.isUnsubscribed()) {
                        s2.onError(e2);
                    }
                    return;
                }
                if (!bs.isUnsubscribed()) {
                    s2.onCompleted();
                }
            }
        });
    }

    public static Completable fromCallable(final Callable<?> callable) {
        Completable.requireNonNull(callable);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                BooleanSubscription bs = new BooleanSubscription();
                s2.onSubscribe(bs);
                try {
                    callable.call();
                }
                catch (Throwable e2) {
                    if (!bs.isUnsubscribed()) {
                        s2.onError(e2);
                    }
                    return;
                }
                if (!bs.isUnsubscribed()) {
                    s2.onCompleted();
                }
            }
        });
    }

    public static Completable fromEmitter(Action1<CompletableEmitter> producer) {
        return Completable.create(new CompletableFromEmitter(producer));
    }

    public static Completable fromFuture(Future<?> future2) {
        Completable.requireNonNull(future2);
        return Completable.fromObservable(Observable.from(future2));
    }

    public static Completable fromObservable(final Observable<?> flowable) {
        Completable.requireNonNull(flowable);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber cs) {
                Subscriber<Object> subscriber2 = new Subscriber<Object>(){

                    @Override
                    public void onCompleted() {
                        cs.onCompleted();
                    }

                    @Override
                    public void onError(Throwable t) {
                        cs.onError(t);
                    }

                    @Override
                    public void onNext(Object t) {
                    }
                };
                cs.onSubscribe(subscriber2);
                flowable.unsafeSubscribe(subscriber2);
            }
        });
    }

    public static Completable fromSingle(final Single<?> single2) {
        Completable.requireNonNull(single2);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                SingleSubscriber<Object> te = new SingleSubscriber<Object>(){

                    @Override
                    public void onError(Throwable e2) {
                        s2.onError(e2);
                    }

                    @Override
                    public void onSuccess(Object value) {
                        s2.onCompleted();
                    }
                };
                s2.onSubscribe(te);
                single2.subscribe(te);
            }
        });
    }

    public static Completable merge(Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new CompletableOnSubscribeMergeArray(sources));
    }

    public static Completable merge(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeIterable(sources));
    }

    public static Completable merge(Observable<? extends Completable> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, false);
    }

    public static Completable merge(Observable<? extends Completable> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, false);
    }

    protected static Completable merge0(Observable<? extends Completable> sources, int maxConcurrency, boolean delayErrors) {
        Completable.requireNonNull(sources);
        if (maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        return Completable.create(new CompletableOnSubscribeMerge(sources, maxConcurrency, delayErrors));
    }

    public static Completable mergeDelayError(Completable ... sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeDelayErrorArray(sources));
    }

    public static Completable mergeDelayError(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeDelayErrorIterable(sources));
    }

    public static Completable mergeDelayError(Observable<? extends Completable> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, true);
    }

    public static Completable mergeDelayError(Observable<? extends Completable> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, true);
    }

    public static Completable never() {
        OnSubscribe cos = RxJavaHooks.onCreate(Completable.NEVER.onSubscribe);
        if (cos == Completable.NEVER.onSubscribe) {
            return NEVER;
        }
        return new Completable(cos, false);
    }

    static <T> T requireNonNull(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    public static Completable timer(long delay2, TimeUnit unit) {
        return Completable.timer(delay2, unit, Schedulers.computation());
    }

    public static Completable timer(final long delay2, final TimeUnit unit, final Scheduler scheduler) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
                s2.onSubscribe(mad);
                if (!mad.isUnsubscribed()) {
                    final Scheduler.Worker w = scheduler.createWorker();
                    mad.set(w);
                    w.schedule(new Action0(){

                        @Override
                        public void call() {
                            try {
                                s2.onCompleted();
                            }
                            finally {
                                w.unsubscribe();
                            }
                        }
                    }, delay2, unit);
                }
            }
        });
    }

    static NullPointerException toNpe(Throwable ex) {
        NullPointerException npe = new NullPointerException("Actually not, but can't pass out an exception otherwise...");
        npe.initCause(ex);
        return npe;
    }

    public static <R> Completable using(Func0<R> resourceFunc0, Func1<? super R, ? extends Completable> completableFunc1, Action1<? super R> disposer) {
        return Completable.using(resourceFunc0, completableFunc1, disposer, true);
    }

    public static <R> Completable using(final Func0<R> resourceFunc0, final Func1<? super R, ? extends Completable> completableFunc1, final Action1<? super R> disposer, final boolean eager) {
        Completable.requireNonNull(resourceFunc0);
        Completable.requireNonNull(completableFunc1);
        Completable.requireNonNull(disposer);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                Completable cs;
                Object resource2;
                try {
                    resource2 = resourceFunc0.call();
                }
                catch (Throwable e2) {
                    s2.onSubscribe(Subscriptions.unsubscribed());
                    s2.onError(e2);
                    return;
                }
                try {
                    cs = (Completable)completableFunc1.call(resource2);
                }
                catch (Throwable e3) {
                    try {
                        disposer.call(resource2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(e3);
                        Exceptions.throwIfFatal(ex);
                        s2.onSubscribe(Subscriptions.unsubscribed());
                        s2.onError(new CompositeException(Arrays.asList(e3, ex)));
                        return;
                    }
                    Exceptions.throwIfFatal(e3);
                    s2.onSubscribe(Subscriptions.unsubscribed());
                    s2.onError(e3);
                    return;
                }
                if (cs == null) {
                    try {
                        disposer.call(resource2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        s2.onSubscribe(Subscriptions.unsubscribed());
                        s2.onError(new CompositeException(Arrays.asList(new NullPointerException("The completable supplied is null"), ex)));
                        return;
                    }
                    s2.onSubscribe(Subscriptions.unsubscribed());
                    s2.onError(new NullPointerException("The completable supplied is null"));
                    return;
                }
                final AtomicBoolean once = new AtomicBoolean();
                cs.unsafeSubscribe(new CompletableSubscriber(){
                    Subscription d;

                    void dispose() {
                        this.d.unsubscribe();
                        if (once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource2);
                            }
                            catch (Throwable ex) {
                                RxJavaHooks.onError(ex);
                            }
                        }
                    }

                    @Override
                    public void onCompleted() {
                        if (eager && once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource2);
                            }
                            catch (Throwable ex) {
                                s2.onError(ex);
                                return;
                            }
                        }
                        s2.onCompleted();
                        if (!eager) {
                            this.dispose();
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        if (eager && once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource2);
                            }
                            catch (Throwable ex) {
                                e2 = new CompositeException(Arrays.asList(e2, ex));
                            }
                        }
                        s2.onError(e2);
                        if (!eager) {
                            this.dispose();
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        this.d = d;
                        s2.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                this.dispose();
                            }
                        }));
                    }
                });
            }
        });
    }

    protected Completable(OnSubscribe onSubscribe) {
        this.onSubscribe = RxJavaHooks.onCreate(onSubscribe);
    }

    protected Completable(OnSubscribe onSubscribe, boolean useHook) {
        this.onSubscribe = useHook ? RxJavaHooks.onCreate(onSubscribe) : onSubscribe;
    }

    public final Completable ambWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.amb(this, other);
    }

    public final void await() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                err[0] = e2;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                Exceptions.propagate(err[0]);
            }
            return;
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (err[0] != null) {
            Exceptions.propagate(err[0]);
        }
    }

    public final boolean await(long timeout, TimeUnit unit) {
        boolean b;
        Completable.requireNonNull(unit);
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                err[0] = e2;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                Exceptions.propagate(err[0]);
            }
            return true;
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (b && err[0] != null) {
            Exceptions.propagate(err[0]);
        }
        return b;
    }

    public final Completable compose(Transformer transformer) {
        return this.to(transformer);
    }

    public final <T> Observable<T> andThen(Observable<T> next2) {
        Completable.requireNonNull(next2);
        return next2.delaySubscription(this.toObservable());
    }

    public final <T> Single<T> andThen(Single<T> next2) {
        Completable.requireNonNull(next2);
        return next2.delaySubscription(this.toObservable());
    }

    public final Completable andThen(Completable next2) {
        return this.concatWith(next2);
    }

    public final Completable concatWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.concat(this, other);
    }

    public final Completable delay(long delay2, TimeUnit unit) {
        return this.delay(delay2, unit, Schedulers.computation(), false);
    }

    public final Completable delay(long delay2, TimeUnit unit, Scheduler scheduler) {
        return this.delay(delay2, unit, scheduler, false);
    }

    public final Completable delay(final long delay2, final TimeUnit unit, final Scheduler scheduler, final boolean delayError) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                final CompositeSubscription set2 = new CompositeSubscription();
                final Scheduler.Worker w = scheduler.createWorker();
                set2.add(w);
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        set2.add(w.schedule(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    s2.onCompleted();
                                }
                                finally {
                                    w.unsubscribe();
                                }
                            }
                        }, delay2, unit));
                    }

                    @Override
                    public void onError(final Throwable e2) {
                        if (delayError) {
                            set2.add(w.schedule(new Action0(){

                                @Override
                                public void call() {
                                    try {
                                        s2.onError(e2);
                                    }
                                    finally {
                                        w.unsubscribe();
                                    }
                                }
                            }, delay2, unit));
                        } else {
                            s2.onError(e2);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set2.add(d);
                        s2.onSubscribe(set2);
                    }
                });
            }
        });
    }

    public final Completable doOnCompleted(Action0 onCompleted) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), onCompleted, Actions.empty(), Actions.empty());
    }

    public final Completable doOnEach(final Action1<Notification<Object>> onNotification) {
        if (onNotification == null) {
            throw new IllegalArgumentException("onNotification is null");
        }
        return this.doOnLifecycle(Actions.empty(), (Action1<? super Throwable>)new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                onNotification.call(Notification.createOnError(throwable));
            }
        }, new Action0(){

            @Override
            public void call() {
                onNotification.call(Notification.createOnCompleted());
            }
        }, Actions.empty(), Actions.empty());
    }

    public final Completable doOnUnsubscribe(Action0 onUnsubscribe) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), Actions.empty(), Actions.empty(), onUnsubscribe);
    }

    public final Completable doOnError(Action1<? super Throwable> onError) {
        return this.doOnLifecycle(Actions.empty(), onError, Actions.empty(), Actions.empty(), Actions.empty());
    }

    protected final Completable doOnLifecycle(final Action1<? super Subscription> onSubscribe, final Action1<? super Throwable> onError, final Action0 onComplete, final Action0 onAfterTerminate, final Action0 onUnsubscribe) {
        Completable.requireNonNull(onSubscribe);
        Completable.requireNonNull(onError);
        Completable.requireNonNull(onComplete);
        Completable.requireNonNull(onAfterTerminate);
        Completable.requireNonNull(onUnsubscribe);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        try {
                            onComplete.call();
                        }
                        catch (Throwable e2) {
                            s2.onError(e2);
                            return;
                        }
                        s2.onCompleted();
                        try {
                            onAfterTerminate.call();
                        }
                        catch (Throwable e3) {
                            RxJavaHooks.onError(e3);
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        try {
                            onError.call(e2);
                        }
                        catch (Throwable ex) {
                            e2 = new CompositeException(Arrays.asList(e2, ex));
                        }
                        s2.onError(e2);
                        try {
                            onAfterTerminate.call();
                        }
                        catch (Throwable ex) {
                            RxJavaHooks.onError(ex);
                        }
                    }

                    @Override
                    public void onSubscribe(final Subscription d) {
                        try {
                            onSubscribe.call(d);
                        }
                        catch (Throwable ex) {
                            d.unsubscribe();
                            s2.onSubscribe(Subscriptions.unsubscribed());
                            s2.onError(ex);
                            return;
                        }
                        s2.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    onUnsubscribe.call();
                                }
                                catch (Throwable e2) {
                                    RxJavaHooks.onError(e2);
                                }
                                d.unsubscribe();
                            }
                        }));
                    }
                });
            }
        });
    }

    public final Completable doOnSubscribe(Action1<? super Subscription> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Actions.empty(), Actions.empty(), Actions.empty(), Actions.empty());
    }

    public final Completable doOnTerminate(final Action0 onTerminate) {
        return this.doOnLifecycle(Actions.empty(), (Action1<? super Throwable>)new Action1<Throwable>(){

            @Override
            public void call(Throwable e2) {
                onTerminate.call();
            }
        }, onTerminate, Actions.empty(), Actions.empty());
    }

    public final Completable doAfterTerminate(Action0 onAfterTerminate) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), Actions.empty(), onAfterTerminate, Actions.empty());
    }

    public final Throwable get() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                err[0] = e2;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        return err[0];
    }

    public final Throwable get(long timeout, TimeUnit unit) {
        boolean b;
        Completable.requireNonNull(unit);
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                err[0] = e2;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (b) {
            return err[0];
        }
        Exceptions.propagate(new TimeoutException());
        return null;
    }

    public final Completable lift(final Operator onLift) {
        Completable.requireNonNull(onLift);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(CompletableSubscriber s2) {
                try {
                    Operator onLiftDecorated = RxJavaHooks.onCompletableLift(onLift);
                    CompletableSubscriber sw = (CompletableSubscriber)onLiftDecorated.call(s2);
                    Completable.this.unsafeSubscribe(sw);
                }
                catch (NullPointerException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw Completable.toNpe(ex);
                }
            }
        });
    }

    public final Completable mergeWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.merge(this, other);
    }

    public final Completable observeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                final SubscriptionList ad = new SubscriptionList();
                final Scheduler.Worker w = scheduler.createWorker();
                ad.add(w);
                s2.onSubscribe(ad);
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        w.schedule(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    s2.onCompleted();
                                }
                                finally {
                                    ad.unsubscribe();
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(final Throwable e2) {
                        w.schedule(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    s2.onError(e2);
                                }
                                finally {
                                    ad.unsubscribe();
                                }
                            }
                        });
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        ad.add(d);
                    }
                });
            }
        });
    }

    public final Completable onErrorComplete() {
        return this.onErrorComplete(UtilityFunctions.alwaysTrue());
    }

    public final Completable onErrorComplete(final Func1<? super Throwable, Boolean> predicate) {
        Completable.requireNonNull(predicate);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s2.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        boolean b;
                        try {
                            b = (Boolean)predicate.call(e2);
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            e2 = new CompositeException(Arrays.asList(e2, ex));
                            b = false;
                        }
                        if (b) {
                            s2.onCompleted();
                        } else {
                            s2.onError(e2);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        s2.onSubscribe(d);
                    }
                });
            }
        });
    }

    public final Completable onErrorResumeNext(final Func1<? super Throwable, ? extends Completable> errorMapper) {
        Completable.requireNonNull(errorMapper);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                final SerialSubscription sd = new SerialSubscription();
                s2.onSubscribe(sd);
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s2.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        Completable c;
                        try {
                            c = (Completable)errorMapper.call(e2);
                        }
                        catch (Throwable ex) {
                            e2 = new CompositeException(Arrays.asList(e2, ex));
                            s2.onError(e2);
                            return;
                        }
                        if (c == null) {
                            NullPointerException npe = new NullPointerException("The completable returned is null");
                            e2 = new CompositeException(Arrays.asList(e2, npe));
                            s2.onError(e2);
                            return;
                        }
                        c.unsafeSubscribe(new CompletableSubscriber(){

                            @Override
                            public void onCompleted() {
                                s2.onCompleted();
                            }

                            @Override
                            public void onError(Throwable e2) {
                                s2.onError(e2);
                            }

                            @Override
                            public void onSubscribe(Subscription d) {
                                sd.set(d);
                            }
                        });
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        sd.set(d);
                    }
                });
            }
        });
    }

    public final Completable repeat() {
        return Completable.fromObservable(this.toObservable().repeat());
    }

    public final Completable repeat(long times) {
        return Completable.fromObservable(this.toObservable().repeat(times));
    }

    public final Completable repeatWhen(Func1<? super Observable<? extends Void>, ? extends Observable<?>> handler) {
        Completable.requireNonNull(handler);
        return Completable.fromObservable(this.toObservable().repeatWhen(handler));
    }

    public final Completable retry() {
        return Completable.fromObservable(this.toObservable().retry());
    }

    public final Completable retry(Func2<Integer, Throwable, Boolean> predicate) {
        return Completable.fromObservable(this.toObservable().retry(predicate));
    }

    public final Completable retry(long times) {
        return Completable.fromObservable(this.toObservable().retry(times));
    }

    public final Completable retryWhen(Func1<? super Observable<? extends Throwable>, ? extends Observable<?>> handler) {
        return Completable.fromObservable(this.toObservable().retryWhen(handler));
    }

    public final Completable startWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.concat(other, this);
    }

    public final <T> Observable<T> startWith(Observable<T> other) {
        Completable.requireNonNull(other);
        return this.toObservable().startWith(other);
    }

    public final Subscription subscribe() {
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                mad.unsubscribe();
            }

            @Override
            public void onError(Throwable e2) {
                RxJavaHooks.onError(e2);
                mad.unsubscribe();
                Completable.deliverUncaughtException(e2);
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    public final Subscription subscribe(final Action0 onComplete) {
        Completable.requireNonNull(onComplete);
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){
            boolean done;

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    try {
                        onComplete.call();
                    }
                    catch (Throwable e2) {
                        RxJavaHooks.onError(e2);
                        Completable.deliverUncaughtException(e2);
                    }
                    finally {
                        mad.unsubscribe();
                    }
                }
            }

            @Override
            public void onError(Throwable e2) {
                RxJavaHooks.onError(e2);
                mad.unsubscribe();
                Completable.deliverUncaughtException(e2);
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    public final Subscription subscribe(final Action0 onComplete, final Action1<? super Throwable> onError) {
        Completable.requireNonNull(onComplete);
        Completable.requireNonNull(onError);
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){
            boolean done;

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    try {
                        onComplete.call();
                    }
                    catch (Throwable e2) {
                        this.callOnError(e2);
                        return;
                    }
                    mad.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    this.done = true;
                    this.callOnError(e2);
                } else {
                    RxJavaHooks.onError(e2);
                    Completable.deliverUncaughtException(e2);
                }
            }

            void callOnError(Throwable e2) {
                try {
                    onError.call(e2);
                }
                catch (Throwable ex) {
                    e2 = new CompositeException(Arrays.asList(e2, ex));
                    RxJavaHooks.onError(e2);
                    Completable.deliverUncaughtException(e2);
                }
                finally {
                    mad.unsubscribe();
                }
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    static void deliverUncaughtException(Throwable e2) {
        Thread thread2 = Thread.currentThread();
        thread2.getUncaughtExceptionHandler().uncaughtException(thread2, e2);
    }

    public final void unsafeSubscribe(CompletableSubscriber s2) {
        Completable.requireNonNull(s2);
        try {
            OnSubscribe onSubscribeDecorated = RxJavaHooks.onCompletableStart(this, this.onSubscribe);
            onSubscribeDecorated.call(s2);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            ex = RxJavaHooks.onCompletableError(ex);
            RxJavaHooks.onError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public final void subscribe(CompletableSubscriber s2) {
        if (!(s2 instanceof SafeCompletableSubscriber)) {
            s2 = new SafeCompletableSubscriber(s2);
        }
        this.unsafeSubscribe(s2);
    }

    public final <T> void unsafeSubscribe(Subscriber<T> s2) {
        this.unsafeSubscribe(s2, true);
    }

    private <T> void unsafeSubscribe(final Subscriber<T> s2, boolean callOnStart) {
        Completable.requireNonNull(s2);
        try {
            if (callOnStart) {
                s2.onStart();
            }
            this.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onCompleted() {
                    s2.onCompleted();
                }

                @Override
                public void onError(Throwable e2) {
                    s2.onError(e2);
                }

                @Override
                public void onSubscribe(Subscription d) {
                    s2.add(d);
                }
            });
            RxJavaHooks.onObservableReturn(s2);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            ex = RxJavaHooks.onObservableError(ex);
            RxJavaHooks.onError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public final <T> void subscribe(Subscriber<T> s2) {
        s2.onStart();
        if (!(s2 instanceof SafeSubscriber)) {
            s2 = new SafeSubscriber<T>(s2);
        }
        this.unsafeSubscribe(s2, false);
    }

    public final Completable subscribeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                final Scheduler.Worker w = scheduler.createWorker();
                w.schedule(new Action0(){

                    @Override
                    public void call() {
                        try {
                            Completable.this.unsafeSubscribe(s2);
                        }
                        finally {
                            w.unsubscribe();
                        }
                    }
                });
            }
        });
    }

    public final Completable timeout(long timeout, TimeUnit unit) {
        return this.timeout0(timeout, unit, Schedulers.computation(), null);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Completable other) {
        Completable.requireNonNull(other);
        return this.timeout0(timeout, unit, Schedulers.computation(), other);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.timeout0(timeout, unit, scheduler, null);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Scheduler scheduler, Completable other) {
        Completable.requireNonNull(other);
        return this.timeout0(timeout, unit, scheduler, other);
    }

    public final Completable timeout0(long timeout, TimeUnit unit, Scheduler scheduler, Completable other) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribeTimeout(this, timeout, unit, scheduler, other));
    }

    public final <R> R to(Func1<? super Completable, R> converter) {
        return converter.call(this);
    }

    public final <T> Observable<T> toObservable() {
        return Observable.unsafeCreate(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> s2) {
                Completable.this.unsafeSubscribe(s2);
            }
        });
    }

    public final <T> Single<T> toSingle(final Func0<? extends T> completionValueFunc0) {
        Completable.requireNonNull(completionValueFunc0);
        return Single.create(new Single.OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> s2) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        Object v;
                        try {
                            v = completionValueFunc0.call();
                        }
                        catch (Throwable e2) {
                            s2.onError(e2);
                            return;
                        }
                        if (v == null) {
                            s2.onError(new NullPointerException("The value supplied is null"));
                        } else {
                            s2.onSuccess(v);
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        s2.onError(e2);
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        s2.add(d);
                    }
                });
            }
        });
    }

    public final <T> Single<T> toSingleDefault(final T completionValue) {
        Completable.requireNonNull(completionValue);
        return this.toSingle(new Func0<T>(){

            @Override
            public T call() {
                return completionValue;
            }
        });
    }

    public final Completable unsubscribeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new OnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s2) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s2.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        s2.onError(e2);
                    }

                    @Override
                    public void onSubscribe(final Subscription d) {
                        s2.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                final Scheduler.Worker w = scheduler.createWorker();
                                w.schedule(new Action0(){

                                    @Override
                                    public void call() {
                                        try {
                                            d.unsubscribe();
                                        }
                                        finally {
                                            w.unsubscribe();
                                        }
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
    }

    public final AssertableSubscriber<Void> test() {
        AssertableSubscriberObservable<Void> ts = AssertableSubscriberObservable.create(Long.MAX_VALUE);
        this.subscribe(ts);
        return ts;
    }

    public static interface Transformer
    extends Func1<Completable, Completable> {
    }

    public static interface Operator
    extends Func1<CompletableSubscriber, CompletableSubscriber> {
    }

    public static interface OnSubscribe
    extends Action1<CompletableSubscriber> {
    }
}

