/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscChunkedArrayQueueColdProducerFields;
import org.jctools.queues.MpscChunkedArrayQueueConsumerFields;
import org.jctools.queues.MpscChunkedArrayQueueProducerFields;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeAccess;
import org.jctools.util.UnsafeRefArrayAccess;

public class MpscChunkedArrayQueue<E>
extends MpscChunkedArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    long p0;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long P_LIMIT_OFFSET;
    private static final Object JUMP;

    public MpscChunkedArrayQueue(int maxCapacity) {
        this(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity, false);
    }

    public MpscChunkedArrayQueue(int initialCapacity, int maxCapacity, boolean fixedChunkSize) {
        if (initialCapacity < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        if (maxCapacity < 4) {
            throw new IllegalArgumentException("Max capacity must be 4 or more");
        }
        if (Pow2.roundToPowerOfTwo(initialCapacity) >= Pow2.roundToPowerOfTwo(maxCapacity)) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = (long)Pow2.roundToPowerOfTwo(maxCapacity) << 1;
        this.isFixedChunkSize = fixedChunkSize;
        this.soProducerLimit(mask);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2) {
        Object[] buffer;
        long mask;
        long pIndex;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result = this.offerSlowPath(mask, buffer, pIndex, producerLimit);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, this.consumerIndex, this.maxQueueCapacity, e2);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soElement(buffer, offset, e2);
        return true;
    }

    private int offerSlowPath(long mask, E[] buffer, long pIndex, long producerLimit) {
        long consumerIndex = this.lvConsumerIndex();
        long maxQueueCapacity = this.maxQueueCapacity;
        long bufferCapacity = this.getCurrentBufferCapacity(mask, maxQueueCapacity);
        int result = 0;
        if (consumerIndex + bufferCapacity > pIndex) {
            if (!this.casProducerLimit(producerLimit, consumerIndex + bufferCapacity)) {
                result = 1;
            }
        } else {
            result = consumerIndex == pIndex - maxQueueCapacity ? 2 : (this.casProducerIndex(pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result;
    }

    private static long modifiedCalcElementOffset(long index2, long mask) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((index2 & mask) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT - 1);
    }

    @Override
    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null) {
            if (index2 != this.lvProducerIndex()) {
                while ((e2 = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e2 == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return (E)e2;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null && index2 != this.lvProducerIndex()) {
            while ((e2 = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
            }
        }
        if (e2 == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e2;
    }

    private E[] getNextBuffer(E[] buffer, long mask) {
        long nextArrayOffset = this.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])UnsafeRefArrayAccess.lvElement(buffer, nextArrayOffset);
        UnsafeRefArrayAccess.soElement(buffer, nextArrayOffset, null);
        return nextBuffer;
    }

    private long nextArrayOffset(long mask) {
        return MpscChunkedArrayQueue.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        E n = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(nextBuffer, offsetInNew, null);
        this.soConsumerIndex(index2 + 2L);
        return n;
    }

    private E newBufferPeek(E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        E n = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return n;
    }

    private long newBufferAndOffset(E[] nextBuffer, long index2) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = nextBuffer.length - 2 << 1;
        long offsetInNew = MpscChunkedArrayQueue.modifiedCalcElementOffset(index2, this.consumerMask);
        return offsetInNew;
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after) >> 1;
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private boolean casProducerIndex(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, expect, newValue);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, expect, newValue);
    }

    private void soProducerLimit(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, v);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return (E)e2;
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int batchSize) {
        long batchIndex;
        Object[] buffer;
        long mask;
        long pIndex;
        block5: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            batchIndex = Math.min(producerLimit, pIndex + (long)(2 * batchSize));
            if (pIndex == producerLimit || producerLimit < batchIndex) {
                int result = this.offerSlowPath(mask, buffer, pIndex, producerLimit);
                switch (result) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, this.consumerIndex, this.maxQueueCapacity, s2.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        int i = 0;
        for (i = 0; i < claimedSlots; ++i) {
            long offset = MpscChunkedArrayQueue.modifiedCalcElementOffset(pIndex + (long)(2 * i), mask);
            UnsafeRefArrayAccess.soElement(buffer, offset, s2.get());
        }
        return claimedSlots;
    }

    private void resize(long mask, E[] buffer, long pIndex, long consumerIndex, long maxQueueCapacity, E e2) {
        int newBufferLength = this.getNextBufferCapacity(buffer, maxQueueCapacity);
        E[] newBuffer = CircularArrayOffsetCalculator.allocate(newBufferLength);
        this.producerBuffer = newBuffer;
        this.producerMask = newBufferLength - 2 << 1;
        long offsetInOld = MpscChunkedArrayQueue.modifiedCalcElementOffset(pIndex, mask);
        long offsetInNew = MpscChunkedArrayQueue.modifiedCalcElementOffset(pIndex, this.producerMask);
        UnsafeRefArrayAccess.soElement(newBuffer, offsetInNew, e2);
        UnsafeRefArrayAccess.soElement(buffer, this.nextArrayOffset(mask), newBuffer);
        long available = maxQueueCapacity - (pIndex - consumerIndex);
        if (available <= 0L) {
            throw new IllegalStateException();
        }
        this.soProducerLimit(pIndex + Math.min(mask, available));
        UnsafeRefArrayAccess.soElement(buffer, offsetInOld, JUMP);
        this.soProducerIndex(pIndex + 2L);
    }

    private int getNextBufferCapacity(E[] buffer, long maxQueueCapacity) {
        int newBufferLength = buffer.length;
        if (this.isFixedChunkSize) {
            newBufferLength = buffer.length;
        } else {
            if ((long)(buffer.length - 1) == maxQueueCapacity) {
                throw new IllegalStateException();
            }
            newBufferLength = 2 * buffer.length - 1;
        }
        return newBufferLength;
    }

    protected long getCurrentBufferCapacity(long mask, long maxQueueCapacity) {
        return !this.isFixedChunkSize && mask + 2L == maxQueueCapacity ? maxQueueCapacity : mask;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s2, MpmcArrayQueue.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            while (this.fill(s2, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) != 0) {
            }
            int idleCounter = 0;
            while (this.fill(s2, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) == 0 && exit.keepRunning()) {
                idleCounter = w.idle(idleCounter);
            }
        }
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e2 = this.relaxedPoll();
            if (e2 == null) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e2);
        }
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit2) {
        E m3;
        int i;
        for (i = 0; i < limit2 && (m3 = this.relaxedPoll()) != null; ++i) {
            c.accept(m3);
        }
        return i;
    }

    static {
        Field iField;
        try {
            iField = MpscChunkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
        try {
            iField = MpscChunkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException(e3);
        }
        try {
            iField = MpscChunkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e4) {
            throw new RuntimeException(e4);
        }
        JUMP = new Object();
    }
}

