/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String source2) {
        this(null, source2, null);
    }

    public NTEventLogAppender(String server2, String source2) {
        this(server2, source2, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String source2, Layout layout) {
        this(null, source2, layout);
    }

    public NTEventLogAppender(String server2, String source2, Layout layout) {
        if (source2 == null) {
            source2 = "Log4j";
        }
        this.layout = layout == null ? new TTCCLayout() : layout;
        try {
            this._handle = this.registerEventSource(server2, source2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this._handle = 0;
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception e2) {
                LogLog.error("Could not register event source.", e2);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent event) {
        String[] s2;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s2 = event.getThrowableStrRep()) != null) {
            int len = s2.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(s2[i]);
            }
        }
        int nt_category = event.getLevel().toInt();
        this.reportEvent(this._handle, sbuf.toString(), nt_category);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String source2) {
        this.source = source2.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        String[] archs;
        try {
            archs = new String[]{System.getProperty("os.arch")};
        }
        catch (SecurityException e2) {
            archs = new String[]{"amd64", "ia64", "x86"};
        }
        boolean loaded = false;
        for (int i = 0; i < archs.length; ++i) {
            try {
                System.loadLibrary("NTEventLogAppender." + archs[i]);
                loaded = true;
                break;
            }
            catch (UnsatisfiedLinkError e3) {
                loaded = false;
                continue;
            }
        }
        if (!loaded) {
            System.loadLibrary("NTEventLogAppender");
        }
    }
}

