/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class PruneColumns
extends TypeUtil.SchemaVisitor<Type> {
    private final Set<Integer> selected;

    PruneColumns(Set<Integer> selected) {
        this.selected = selected;
    }

    @Override
    public Type schema(Schema schema, Type structResult) {
        return structResult;
    }

    @Override
    public Type struct(Types.StructType struct2, List<Type> fieldResults) {
        List<Types.NestedField> fields = struct2.fields();
        ArrayList<Types.NestedField> selectedFields = Lists.newArrayListWithExpectedSize(fields.size());
        boolean sameTypes = true;
        for (int i = 0; i < fieldResults.size(); ++i) {
            Types.NestedField field = fields.get(i);
            Type projectedType = fieldResults.get(i);
            if (field.type() == projectedType) {
                selectedFields.add(field);
                continue;
            }
            if (projectedType == null) continue;
            sameTypes = false;
            if (field.isOptional()) {
                selectedFields.add(Types.NestedField.optional(field.fieldId(), field.name(), projectedType, field.doc()));
                continue;
            }
            selectedFields.add(Types.NestedField.required(field.fieldId(), field.name(), projectedType, field.doc()));
        }
        if (!selectedFields.isEmpty()) {
            if (selectedFields.size() == fields.size() && sameTypes) {
                return struct2;
            }
            return Types.StructType.of(selectedFields);
        }
        return null;
    }

    @Override
    public Type field(Types.NestedField field, Type fieldResult) {
        if (this.selected.contains(field.fieldId())) {
            return field.type();
        }
        if (fieldResult != null) {
            return fieldResult;
        }
        return null;
    }

    @Override
    public Type list(Types.ListType list, Type elementResult) {
        if (this.selected.contains(list.elementId())) {
            return list;
        }
        if (elementResult != null) {
            if (list.elementType() == elementResult) {
                return list;
            }
            if (list.isElementOptional()) {
                return Types.ListType.ofOptional(list.elementId(), elementResult);
            }
            return Types.ListType.ofRequired(list.elementId(), elementResult);
        }
        return null;
    }

    @Override
    public Type map(Types.MapType map2, Type ignored, Type valueResult) {
        if (this.selected.contains(map2.valueId())) {
            return map2;
        }
        if (valueResult != null) {
            if (map2.valueType() == valueResult) {
                return map2;
            }
            if (map2.isValueOptional()) {
                return Types.MapType.ofOptional(map2.keyId(), map2.valueId(), map2.keyType(), valueResult);
            }
            return Types.MapType.ofRequired(map2.keyId(), map2.valueId(), map2.keyType(), valueResult);
        }
        if (this.selected.contains(map2.keyId())) {
            return map2;
        }
        return null;
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return null;
    }
}

