/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Conversions {
    private static final String HIVE_NULL = "__HIVE_DEFAULT_PARTITION__";
    private static final ThreadLocal<CharsetEncoder> ENCODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final ThreadLocal<CharsetDecoder> DECODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);

    private Conversions() {
    }

    public static Object fromPartitionString(Type type2, String asString) {
        if (asString == null || HIVE_NULL.equals(asString)) {
            return null;
        }
        switch (type2.typeId()) {
            case BOOLEAN: {
                return Boolean.valueOf(asString);
            }
            case INTEGER: {
                return Integer.valueOf(asString);
            }
            case LONG: {
                return Long.valueOf(asString);
            }
            case FLOAT: {
                return Float.valueOf(asString);
            }
            case DOUBLE: {
                return Double.valueOf(asString);
            }
            case STRING: {
                return asString;
            }
            case UUID: {
                return UUID.fromString(asString);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)type2;
                return Arrays.copyOf(asString.getBytes(StandardCharsets.UTF_8), fixed.length());
            }
            case BINARY: {
                return asString.getBytes(StandardCharsets.UTF_8);
            }
            case DECIMAL: {
                return new BigDecimal(asString);
            }
            case DATE: {
                return Literal.of(asString).to(Types.DateType.get()).value();
            }
        }
        throw new UnsupportedOperationException("Unsupported type for fromPartitionString: " + type2);
    }

    public static ByteBuffer toByteBuffer(Type type2, Object value) {
        return Conversions.toByteBuffer(type2.typeId(), value);
    }

    public static ByteBuffer toByteBuffer(Type.TypeID typeId, Object value) {
        if (value == null) {
            return null;
        }
        switch (typeId) {
            case BOOLEAN: {
                return ByteBuffer.allocate(1).put(0, (Boolean)value != false ? (byte)1 : 0);
            }
            case INTEGER: 
            case DATE: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(0, (Integer)value);
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, (Long)value);
            }
            case FLOAT: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(0, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, (Double)value);
            }
            case STRING: {
                CharBuffer buffer = CharBuffer.wrap((CharSequence)value);
                try {
                    return ENCODER.get().encode(buffer);
                }
                catch (CharacterCodingException e2) {
                    throw new RuntimeIOException(e2, "Failed to encode value as UTF-8: " + value, new Object[0]);
                }
            }
            case UUID: {
                UUID uuid2 = (UUID)value;
                return ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(0, uuid2.getMostSignificantBits()).putLong(8, uuid2.getLeastSignificantBits());
            }
            case FIXED: 
            case BINARY: {
                return (ByteBuffer)value;
            }
            case DECIMAL: {
                return ByteBuffer.wrap(((BigDecimal)value).unscaledValue().toByteArray());
            }
        }
        throw new UnsupportedOperationException("Cannot serialize type: " + (Object)((Object)typeId));
    }

    public static <T> T fromByteBuffer(Type type2, ByteBuffer buffer) {
        return (T)Conversions.internalFromByteBuffer(type2, buffer);
    }

    private static Object internalFromByteBuffer(Type type2, ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer tmp = buffer.duplicate();
        if (type2 == Types.UUIDType.get() || type2 instanceof Types.DecimalType) {
            tmp.order(ByteOrder.BIG_ENDIAN);
        } else {
            tmp.order(ByteOrder.LITTLE_ENDIAN);
        }
        switch (type2.typeId()) {
            case BOOLEAN: {
                return tmp.get() != 0;
            }
            case INTEGER: 
            case DATE: {
                return tmp.getInt();
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                if (tmp.remaining() < 8) {
                    return (long)tmp.getInt();
                }
                return tmp.getLong();
            }
            case FLOAT: {
                return Float.valueOf(tmp.getFloat());
            }
            case DOUBLE: {
                if (tmp.remaining() < 8) {
                    return (double)tmp.getFloat();
                }
                return tmp.getDouble();
            }
            case STRING: {
                try {
                    return DECODER.get().decode(tmp);
                }
                catch (CharacterCodingException e2) {
                    throw new RuntimeIOException(e2, "Failed to decode value as UTF-8: " + buffer, new Object[0]);
                }
            }
            case UUID: {
                long mostSigBits = tmp.getLong();
                long leastSigBits = tmp.getLong();
                return new UUID(mostSigBits, leastSigBits);
            }
            case FIXED: 
            case BINARY: {
                return tmp;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)type2;
                byte[] unscaledBytes = new byte[buffer.remaining()];
                tmp.get(unscaledBytes);
                return new BigDecimal(new BigInteger(unscaledBytes), decimal.scale());
            }
        }
        throw new UnsupportedOperationException("Cannot deserialize type: " + type2);
    }
}

