/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Transform;

class ProjectionUtil {
    private ProjectionUtil() {
    }

    static <T> UnboundPredicate<T> truncateInteger(String name2, BoundPredicate<Integer> pred, Transform<Integer, T> transform2) {
        int boundary = (Integer)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary - 1));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary + 1));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name2, transform2.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateIntegerStrict(String name2, BoundPredicate<Integer> pred, Transform<Integer, T> transform2) {
        int boundary = (Integer)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary + 1));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary - 1));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLongStrict(String name2, BoundPredicate<Long> pred, Transform<Long, T> transform2) {
        long boundary = (Long)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary + 1L));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary - 1L));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLong(String name2, BoundPredicate<Long> pred, Transform<Long, T> transform2) {
        long boundary = (Long)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary - 1L));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary + 1L));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name2, transform2.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimal(String name2, BoundPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform2) {
        BigDecimal boundary = (BigDecimal)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(minusOne));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary));
            }
            case GT: {
                BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(plusOne));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name2, transform2.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimalStrict(String name2, BoundPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform2) {
        BigDecimal boundary = (BigDecimal)pred.literal().value();
        BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
        BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(plusOne));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(minusOne));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArray(String name2, BoundPredicate<S> pred, Transform<S, T> transform2) {
        Object boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name2, transform2.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(Expression.Operation.EQ, name2, transform2.apply(boundary));
            }
            case STARTS_WITH: {
                return Expressions.predicate(Expression.Operation.STARTS_WITH, name2, transform2.apply(boundary));
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArrayStrict(String name2, BoundPredicate<S> pred, Transform<S, T> transform2) {
        Object boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name2, transform2.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name2, transform2.apply(boundary));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name2, transform2.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }
}

