/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import com.google.common.base.Preconditions;
import java.util.stream.Stream;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.RewriteNot;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;

public class Expressions {
    private Expressions() {
    }

    public static Expression and(Expression left2, Expression right2) {
        Preconditions.checkNotNull(left2, "Left expression cannot be null.");
        Preconditions.checkNotNull(right2, "Right expression cannot be null.");
        if (left2 == Expressions.alwaysFalse() || right2 == Expressions.alwaysFalse()) {
            return Expressions.alwaysFalse();
        }
        if (left2 == Expressions.alwaysTrue()) {
            return right2;
        }
        if (right2 == Expressions.alwaysTrue()) {
            return left2;
        }
        return new And(left2, right2);
    }

    public static Expression and(Expression left2, Expression right2, Expression ... expressions) {
        return Stream.of(expressions).reduce(Expressions.and(left2, right2), Expressions::and);
    }

    public static Expression or(Expression left2, Expression right2) {
        Preconditions.checkNotNull(left2, "Left expression cannot be null.");
        Preconditions.checkNotNull(right2, "Right expression cannot be null.");
        if (left2 == Expressions.alwaysTrue() || right2 == Expressions.alwaysTrue()) {
            return Expressions.alwaysTrue();
        }
        if (left2 == Expressions.alwaysFalse()) {
            return right2;
        }
        if (right2 == Expressions.alwaysFalse()) {
            return left2;
        }
        return new Or(left2, right2);
    }

    public static Expression not(Expression child) {
        Preconditions.checkNotNull(child, "Child expression cannot be null.");
        if (child == Expressions.alwaysTrue()) {
            return Expressions.alwaysFalse();
        }
        if (child == Expressions.alwaysFalse()) {
            return Expressions.alwaysTrue();
        }
        if (child instanceof Not) {
            return ((Not)child).child();
        }
        return new Not(child);
    }

    public static <T> UnboundPredicate<T> isNull(String name2) {
        return new UnboundPredicate(Expression.Operation.IS_NULL, Expressions.ref(name2));
    }

    public static <T> UnboundPredicate<T> notNull(String name2) {
        return new UnboundPredicate(Expression.Operation.NOT_NULL, Expressions.ref(name2));
    }

    public static <T> UnboundPredicate<T> lessThan(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> lessThanOrEqual(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT_EQ, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> greaterThan(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> greaterThanOrEqual(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT_EQ, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> equal(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.EQ, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> notEqual(String name2, T value) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_EQ, Expressions.ref(name2), value);
    }

    public static UnboundPredicate<String> startsWith(String name2, String value) {
        return new UnboundPredicate<String>(Expression.Operation.STARTS_WITH, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name2, T value) {
        Preconditions.checkArgument(op != Expression.Operation.IS_NULL && op != Expression.Operation.NOT_NULL, "Cannot create %s predicate inclusive a value", (Object)op);
        return new UnboundPredicate<T>(op, Expressions.ref(name2), value);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name2, Literal<T> lit) {
        Preconditions.checkArgument(op != Expression.Operation.IS_NULL && op != Expression.Operation.NOT_NULL, "Cannot create %s predicate inclusive a value", (Object)op);
        return new UnboundPredicate<T>(op, Expressions.ref(name2), lit);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name2) {
        Preconditions.checkArgument(op == Expression.Operation.IS_NULL || op == Expression.Operation.NOT_NULL, "Cannot create %s predicate without a value", (Object)op);
        return new UnboundPredicate(op, Expressions.ref(name2));
    }

    public static True alwaysTrue() {
        return True.INSTANCE;
    }

    public static False alwaysFalse() {
        return False.INSTANCE;
    }

    public static Expression rewriteNot(Expression expr) {
        return ExpressionVisitors.visit(expr, RewriteNot.get());
    }

    static NamedReference ref(String name2) {
        return new NamedReference(name2);
    }
}

