/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.expressions.UnboundPredicate;

public class ExpressionVisitors {
    private ExpressionVisitors() {
    }

    public static <R> R visit(Expression expr, ExpressionVisitor<R> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not2 = (Not)expr;
                return visitor.not(ExpressionVisitors.visit(not2.child(), visitor));
            }
            case AND: {
                And and2 = (And)expr;
                return visitor.and(ExpressionVisitors.visit(and2.left(), visitor), ExpressionVisitors.visit(and2.right(), visitor));
            }
            case OR: {
                Or or2 = (Or)expr;
                return visitor.or(ExpressionVisitors.visit(or2.left(), visitor), ExpressionVisitors.visit(or2.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)expr.op()));
    }

    public static Boolean visitEvaluator(Expression expr, ExpressionVisitor<Boolean> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not2 = (Not)expr;
                return visitor.not(ExpressionVisitors.visitEvaluator(not2.child(), visitor));
            }
            case AND: {
                And and2 = (And)expr;
                Boolean andLeftOperand = ExpressionVisitors.visitEvaluator(and2.left(), visitor);
                if (!andLeftOperand.booleanValue()) {
                    return visitor.alwaysFalse();
                }
                return visitor.and(Boolean.TRUE, ExpressionVisitors.visitEvaluator(and2.right(), visitor));
            }
            case OR: {
                Or or2 = (Or)expr;
                Boolean orLeftOperand = ExpressionVisitors.visitEvaluator(or2.left(), visitor);
                if (orLeftOperand.booleanValue()) {
                    return visitor.alwaysTrue();
                }
                return visitor.or(Boolean.FALSE, ExpressionVisitors.visitEvaluator(or2.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)expr.op()));
    }

    public static abstract class BoundExpressionVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(BoundReference<T> ref2) {
            return null;
        }

        public <T> R notNull(BoundReference<T> ref2) {
            return null;
        }

        public <T> R lt(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R gt(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R eq(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R in(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R notIn(BoundReference<T> ref2, Literal<T> lit) {
            return null;
        }

        public <T> R startsWith(BoundReference<T> ref2, Literal<T> lit) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            switch (pred.op()) {
                case IS_NULL: {
                    return this.isNull((BoundReference)pred.ref());
                }
                case NOT_NULL: {
                    return this.notNull((BoundReference)pred.ref());
                }
                case LT: {
                    return this.lt((BoundReference)pred.ref(), pred.literal());
                }
                case LT_EQ: {
                    return this.ltEq((BoundReference)pred.ref(), pred.literal());
                }
                case GT: {
                    return this.gt((BoundReference)pred.ref(), pred.literal());
                }
                case GT_EQ: {
                    return this.gtEq((BoundReference)pred.ref(), pred.literal());
                }
                case EQ: {
                    return this.eq((BoundReference)pred.ref(), pred.literal());
                }
                case NOT_EQ: {
                    return this.notEq((BoundReference)pred.ref(), pred.literal());
                }
                case IN: {
                    return this.in((BoundReference)pred.ref(), pred.literal());
                }
                case NOT_IN: {
                    return this.notIn((BoundReference)pred.ref(), pred.literal());
                }
                case STARTS_WITH: {
                    return this.startsWith((BoundReference)pred.ref(), pred.literal());
                }
            }
            throw new UnsupportedOperationException("Unknown operation for predicate: " + (Object)((Object)pred.op()));
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + pred);
        }
    }

    public static abstract class ExpressionVisitor<R> {
        public R alwaysTrue() {
            return null;
        }

        public R alwaysFalse() {
            return null;
        }

        public R not(R result) {
            return null;
        }

        public R and(R leftResult, R rightResult) {
            return null;
        }

        public R or(R leftResult, R rightResult) {
            return null;
        }

        public <T> R predicate(BoundPredicate<T> pred) {
            return null;
        }

        public <T> R predicate(UnboundPredicate<T> pred) {
            return null;
        }
    }
}

