/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.events.Listener;

public class Listeners {
    private static final Map<Class<?>, List<Listener<?>>> listeners = Maps.newConcurrentMap();

    private Listeners() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void register(Listener<E> listener, Class<E> eventType) {
        List<Listener<?>> list = listeners.get(eventType);
        if (list == null) {
            Map<Class<?>, List<Listener<?>>> map2 = listeners;
            synchronized (map2) {
                list = listeners.get(eventType);
                if (list == null) {
                    list = Lists.newArrayList();
                    listeners.put(eventType, list);
                }
            }
        }
        list.add(listener);
    }

    public static <E> void notifyAll(E event) {
        Preconditions.checkNotNull(event, "Cannot notify listeners for a null event.");
        List<Listener<?>> list = listeners.get(event.getClass());
        if (list != null) {
            for (Listener<?> listener : list) {
                listener.notify(event);
            }
        }
    }
}

