/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.apache.iceberg.catalog.Namespace;

public class TableIdentifier {
    private static final Splitter DOT = Splitter.on('.');
    private final Namespace namespace;
    private final String name;

    public static TableIdentifier of(String ... names) {
        Preconditions.checkArgument(names.length > 0, "Cannot create table identifier without a table name");
        return new TableIdentifier(Namespace.of(Arrays.copyOf(names, names.length - 1)), names[names.length - 1]);
    }

    public static TableIdentifier of(Namespace namespace2, String name2) {
        return new TableIdentifier(namespace2, name2);
    }

    public static TableIdentifier parse(String identifier) {
        Iterable<String> parts = DOT.split(identifier);
        return TableIdentifier.of(Iterables.toArray(parts, String.class));
    }

    private TableIdentifier(Namespace namespace2, String name2) {
        Preconditions.checkArgument(name2 != null && !name2.isEmpty(), "Invalid table name %s", (Object)name2);
        this.namespace = namespace2;
        this.name = name2;
    }

    public boolean hasNamespace() {
        return !this.namespace.isEmpty();
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.namespace.toString() + "." + this.name;
    }
}

