/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;

public class Files {
    private Files() {
    }

    public static OutputFile localOutput(File file2) {
        return new LocalOutputFile(file2);
    }

    public static OutputFile localOutput(String file2) {
        return Files.localOutput(Paths.get(file2, new String[0]).toAbsolutePath().toFile());
    }

    public static InputFile localInput(File file2) {
        return new LocalInputFile(file2);
    }

    public static InputFile localInput(String file2) {
        if (file2.startsWith("file:")) {
            return Files.localInput(new File(file2.replaceFirst("file:", "")));
        }
        return Files.localInput(new File(file2));
    }

    private static class PositionFileOutputStream
    extends PositionOutputStream {
        private final File file;
        private final RandomAccessFile stream;
        private boolean isClosed = false;

        private PositionFileOutputStream(File file2, RandomAccessFile stream) {
            this.file = file2;
            this.stream = stream;
        }

        @Override
        public long getPos() throws IOException {
            if (this.isClosed) {
                return this.file.length();
            }
            return this.stream.getFilePointer();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.isClosed = true;
        }
    }

    private static class SeekableFileInputStream
    extends SeekableInputStream {
        private final RandomAccessFile stream;

        private SeekableFileInputStream(RandomAccessFile stream) {
            this.stream = stream;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getFilePointer();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                return this.stream.skipBytes(Integer.MAX_VALUE);
            }
            return this.stream.skipBytes((int)n);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    private static class LocalInputFile
    implements InputFile {
        private final File file;

        private LocalInputFile(File file2) {
            this.file = file2;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public SeekableInputStream newStream() {
            try {
                return new SeekableFileInputStream(new RandomAccessFile(this.file, "r"));
            }
            catch (FileNotFoundException e2) {
                throw new NotFoundException(e2, "Failed to read file: %s", this.file);
            }
        }

        @Override
        public String location() {
            return this.file.toString();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        public String toString() {
            return this.location();
        }
    }

    private static class LocalOutputFile
    implements OutputFile {
        private final File file;

        private LocalOutputFile(File file2) {
            this.file = file2;
        }

        @Override
        public PositionOutputStream create() {
            if (this.file.exists()) {
                throw new AlreadyExistsException("File already exists: %s", this.file);
            }
            if (!this.file.getParentFile().isDirectory() && !this.file.getParentFile().mkdirs()) {
                throw new RuntimeIOException(String.format("Failed to create the file's directory at %s.", this.file.getParentFile().getAbsolutePath()), new Object[0]);
            }
            try {
                return new PositionFileOutputStream(this.file, new RandomAccessFile(this.file, "rw"));
            }
            catch (FileNotFoundException e2) {
                throw new NotFoundException(e2, "Failed to create file: %s", this.file);
            }
        }

        @Override
        public PositionOutputStream createOrOverwrite() {
            if (this.file.exists() && !this.file.delete()) {
                throw new RuntimeIOException("Failed to delete: " + this.file, new Object[0]);
            }
            return this.create();
        }

        @Override
        public String location() {
            return this.file.toString();
        }

        @Override
        public InputFile toInputFile() {
            return Files.localInput(this.file);
        }

        public String toString() {
            return this.location();
        }
    }
}

