/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.subscriptions.Subscriptions;

public class BufferOnBackPressureOperator<T>
implements Observable.Operator<T, T> {
    public static final String METRICS_NAME_PREFIX = "DropOperator_";
    private static final Logger logger = LoggerFactory.getLogger(BufferOnBackPressureOperator.class);
    private static final int DEFAULT_SIZE = 4096;
    private final int size;
    private final ArrayBlockingQueue<Object> queue;
    private final Counter next;
    private final Counter error;
    private final Counter complete;
    private final Gauge subscribe;
    private final Gauge requestedGauge;
    private final Counter dropped;
    private final Gauge bufferedGauge;
    private String name;

    public BufferOnBackPressureOperator(String name2) {
        this(name2, 4096);
    }

    public BufferOnBackPressureOperator(Metrics m3, int size) {
        this.size = size;
        this.queue = new ArrayBlockingQueue(size);
        this.next = m3.getCounter("" + (Object)((Object)Counters.onNext));
        this.error = m3.getCounter("" + (Object)((Object)Counters.onError));
        this.complete = m3.getCounter("" + (Object)((Object)Counters.onComplete));
        this.subscribe = m3.getGauge("" + (Object)((Object)Gauges.subscribe));
        this.dropped = m3.getCounter("" + (Object)((Object)Counters.dropped));
        this.requestedGauge = m3.getGauge("" + (Object)((Object)Gauges.requested));
        this.bufferedGauge = m3.getGauge("" + (Object)((Object)Gauges.bufferedGauge));
    }

    public BufferOnBackPressureOperator(String name2, int size) {
        this.size = size;
        this.name = METRICS_NAME_PREFIX + name2;
        this.queue = new ArrayBlockingQueue(size);
        Metrics m3 = new Metrics.Builder().name(this.name).addCounter("" + (Object)((Object)Counters.onNext)).addCounter("" + (Object)((Object)Counters.onError)).addCounter("" + (Object)((Object)Counters.onComplete)).addGauge("" + (Object)((Object)Gauges.subscribe)).addCounter("" + (Object)((Object)Counters.dropped)).addGauge("" + (Object)((Object)Gauges.requested)).addGauge("" + (Object)((Object)Gauges.bufferedGauge)).build();
        m3 = MetricsRegistry.getInstance().registerAndGet(m3);
        this.next = m3.getCounter("" + (Object)((Object)Counters.onNext));
        this.error = m3.getCounter("" + (Object)((Object)Counters.onError));
        this.complete = m3.getCounter("" + (Object)((Object)Counters.onComplete));
        this.subscribe = m3.getGauge("" + (Object)((Object)Gauges.subscribe));
        this.dropped = m3.getCounter("" + (Object)((Object)Counters.dropped));
        this.requestedGauge = m3.getGauge("" + (Object)((Object)Gauges.requested));
        this.bufferedGauge = m3.getGauge("" + (Object)((Object)Gauges.bufferedGauge));
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        this.subscribe.increment();
        final AtomicLong requested = new AtomicLong();
        final AtomicInteger completionEmitted = new AtomicInteger();
        final AtomicInteger terminated = new AtomicInteger();
        final AtomicInteger bufferedCount = new AtomicInteger();
        final AtomicBoolean onCompleteReceived = new AtomicBoolean();
        final AtomicInteger wip = new AtomicInteger();
        child.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                BufferOnBackPressureOperator.this.subscribe.decrement();
            }
        }));
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                requested.getAndAdd(n);
                BufferOnBackPressureOperator.this.requestedGauge.increment(n);
                BufferOnBackPressureOperator.this.pollQueue(child, requested, bufferedCount, onCompleteReceived, completionEmitted, wip);
            }
        });
        Subscriber parent = new Subscriber<T>(){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (terminated.compareAndSet(0, 1)) {
                    BufferOnBackPressureOperator.this.complete.increment();
                    onCompleteReceived.set(true);
                    BufferOnBackPressureOperator.this.pollQueue(child, requested, bufferedCount, onCompleteReceived, completionEmitted, wip);
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (terminated.compareAndSet(0, 1)) {
                    child.onError(e2);
                    BufferOnBackPressureOperator.this.error.increment();
                    BufferOnBackPressureOperator.this.queue.clear();
                }
            }

            @Override
            public void onNext(T t) {
                this.emitItem(NotificationLite.next(t));
            }

            private void emitItem(Object item) {
                if (requested.get() > 0L && BufferOnBackPressureOperator.this.queue.isEmpty()) {
                    NotificationLite.accept(child, item);
                    requested.decrementAndGet();
                    BufferOnBackPressureOperator.this.requestedGauge.decrement();
                    BufferOnBackPressureOperator.this.next.increment();
                } else {
                    boolean success2 = BufferOnBackPressureOperator.this.queue.offer(item);
                    if (success2) {
                        bufferedCount.incrementAndGet();
                        BufferOnBackPressureOperator.this.bufferedGauge.increment();
                        BufferOnBackPressureOperator.this.drainIfPossible(child, requested, bufferedCount, onCompleteReceived, completionEmitted);
                    } else {
                        BufferOnBackPressureOperator.this.dropped.increment();
                    }
                }
            }
        };
        child.add(parent);
        return parent;
    }

    private void drainIfPossible(Subscriber<? super T> child, AtomicLong requested, AtomicInteger bufferedCount, AtomicBoolean onCompleteReceived, AtomicInteger completionEmitted) {
        while (requested.get() > 0L) {
            Object t = this.queue.poll();
            if (t != null) {
                NotificationLite.accept(child, t);
                requested.decrementAndGet();
                this.requestedGauge.decrement();
                bufferedCount.decrementAndGet();
                this.bufferedGauge.decrement();
                continue;
            }
            if (!onCompleteReceived.get() || !completionEmitted.compareAndSet(0, 1)) break;
            child.onCompleted();
            this.queue.clear();
            this.bufferedGauge.set(0L);
            break;
        }
    }

    private void pollQueue(Subscriber<? super T> child, AtomicLong requested, AtomicInteger bufferedCount, AtomicBoolean onCompleteReceived, AtomicInteger completionEmitted, AtomicInteger wip) {
        do {
            this.drainIfPossible(child, requested, bufferedCount, onCompleteReceived, completionEmitted);
            long c = wip.decrementAndGet();
            if (c <= 1L) continue;
            wip.set(1);
        } while (wip.get() > 0);
    }

    public static enum Gauges {
        subscribe,
        requested,
        bufferedGauge;

    }

    public static enum Counters {
        onNext,
        onError,
        onComplete,
        dropped;

    }
}

