/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.Metadata;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.DescriptorException;
import io.mantisrx.runtime.descriptor.JobDescriptor;
import io.mantisrx.runtime.descriptor.JobInfo;
import io.mantisrx.runtime.descriptor.MetadataInfo;
import io.mantisrx.runtime.descriptor.ParameterInfo;
import io.mantisrx.runtime.descriptor.StageInfo;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.ParameterUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateJobDescriptorFile
implements Command {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Job job;
    private final String project;
    private final String version;
    private final File descriptorFile;
    private final boolean readyForJobMaster;

    public CreateJobDescriptorFile(Job job, File descriptorFile, String version, String project2) {
        this(job, descriptorFile, version, project2, false);
    }

    public CreateJobDescriptorFile(Job job, File descriptorFile, String version, String project2, boolean readyForJobMaster) {
        this.job = job;
        this.descriptorFile = descriptorFile;
        this.version = version;
        this.project = project2;
        this.readyForJobMaster = readyForJobMaster;
    }

    private MetadataInfo toMetaDataInfo(Metadata metadata) {
        MetadataInfo metadataInfo = null;
        if (metadata != null) {
            metadataInfo = new MetadataInfo(metadata.getName(), metadata.getDescription());
        }
        return metadataInfo;
    }

    @Override
    public void execute() throws CommandException {
        Metadata jobMetadata = this.job.getMetadata();
        HashMap<Integer, StageInfo> stagesInfo = new HashMap<Integer, StageInfo>();
        List<StageConfig<?, ?>> stages = this.job.getStages();
        int numStages = 0;
        for (StageConfig<?, ?> stage : stages) {
            stagesInfo.put(numStages, new StageInfo(numStages, stage.getDescription()));
            ++numStages;
        }
        Map<String, ParameterInfo> parameterInfo = this.createParameterInfo(this.job.getParameterDefinitions());
        Map<String, ParameterInfo> systemParameterInfo = this.createParameterInfo(ParameterUtils.getSystemParameters());
        int totalNumStages = numStages;
        Map<String, ParameterInfo> sysParams = systemParameterInfo.entrySet().stream().filter(sysParam -> {
            for (int stageNum = totalNumStages + 1; stageNum <= 5; ++stageNum) {
                if (!((String)sysParam.getKey()).equals(String.format("MANTIS_WORKER_JVM_OPTS_STAGE%d", stageNum))) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toMap(e2 -> (String)e2.getKey(), e2 -> (ParameterInfo)e2.getValue()));
        parameterInfo.putAll(sysParams);
        Metadata sourceMetadata = this.job.getSource().getMetadata();
        MetadataInfo sourceMetadataInfo = this.toMetaDataInfo(sourceMetadata);
        Metadata sinkMetadata = this.job.getSink().getMetadata();
        MetadataInfo sinkMetadataInfo = this.toMetaDataInfo(sinkMetadata);
        JobInfo jobInfo = new JobInfo(jobMetadata.getName(), jobMetadata.getDescription(), numStages, parameterInfo, sourceMetadataInfo, sinkMetadataInfo, stagesInfo);
        JobDescriptor jobDescriptor = new JobDescriptor(jobInfo, this.project, this.version, System.currentTimeMillis(), this.readyForJobMaster);
        try {
            mapper.writeValue(this.descriptorFile, (Object)jobDescriptor);
        }
        catch (IOException e3) {
            throw new DescriptorException(e3);
        }
    }

    private Map<String, ParameterInfo> createParameterInfo(Map<String, ParameterDefinition<?>> parameters) {
        HashMap<String, ParameterInfo> parameterInfo = new HashMap<String, ParameterInfo>();
        for (Map.Entry<String, ParameterDefinition<?>> entry : parameters.entrySet()) {
            ParameterDefinition<?> definition = entry.getValue();
            String defaultValue = null;
            if (definition.getDefaultValue() != null) {
                defaultValue = definition.getDefaultValue().toString();
            }
            parameterInfo.put(entry.getKey(), new ParameterInfo(definition.getName(), definition.getDescription(), defaultValue, definition.getTypeDescription(), definition.getValidator().getDescription(), definition.isRequired()));
        }
        return parameterInfo;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

