/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobSla;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.NamedJobDefinition;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.command.InvalidJobException;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class MantisJobDefinition {
    private static final long serialVersionUID = 1L;
    private String name;
    private String user;
    private URL jobJarFileLocation;
    private String version;
    private List<Parameter> parameters;
    private JobSla jobSla;
    private long subscriptionTimeoutSecs = 0L;
    private SchedulingInfo schedulingInfo;
    private int slaMin = 0;
    private int slaMax = 0;
    private String cronSpec = "";
    private NamedJobDefinition.CronPolicy cronPolicy = null;
    private boolean isReadyForJobMaster = false;
    private WorkerMigrationConfig migrationConfig;
    private List<Label> labels;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisJobDefinition(@JsonProperty(value="name") String name2, @JsonProperty(value="user") String user, @JsonProperty(value="url") URL jobJarFileLocation, @JsonProperty(value="version") String version, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="jobSla") JobSla jobSla, @JsonProperty(value="subscriptionTimeoutSecs") long subscriptionTimeoutSecs, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo, @JsonProperty(value="slaMin") int slaMin, @JsonProperty(value="slaMax") int slaMax, @JsonProperty(value="cronSpec") String cronSpec, @JsonProperty(value="cronPolicy") NamedJobDefinition.CronPolicy cronPolicy, @JsonProperty(value="isReadyForJobMaster") boolean isReadyForJobMaster, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="labels") List<Label> labels) {
        this.name = name2;
        this.user = user;
        this.jobJarFileLocation = jobJarFileLocation;
        this.version = version;
        this.parameters = parameters != null ? parameters : new LinkedList<Parameter>();
        this.labels = labels != null ? labels : new LinkedList<Label>();
        this.jobSla = jobSla;
        if (subscriptionTimeoutSecs > 0L) {
            this.subscriptionTimeoutSecs = subscriptionTimeoutSecs;
        }
        this.schedulingInfo = schedulingInfo;
        this.slaMin = slaMin;
        this.slaMax = slaMax;
        this.cronSpec = cronSpec;
        this.cronPolicy = cronPolicy;
        this.isReadyForJobMaster = isReadyForJobMaster;
        this.migrationConfig = Optional.ofNullable(migrationConfig).orElse(WorkerMigrationConfig.DEFAULT);
    }

    public void validate(boolean schedulingInfoOptional) throws InvalidJobException {
        this.validateSla();
        this.validateSchedulingInfo(schedulingInfoOptional);
    }

    private void validateSla() throws InvalidJobException {
        if (this.jobSla == null) {
            throw new InvalidJobException("No Job SLA provided (likely incorrect job submit request)");
        }
        if (this.jobSla.getDurationType() == null) {
            throw new InvalidJobException("Invalid null duration type in job sla (likely incorrect job submit request");
        }
    }

    public void validateSchedulingInfo() throws InvalidJobException {
        this.validateSchedulingInfo(false);
    }

    private void validateSchedulingInfo(boolean schedulingInfoOptional) throws InvalidJobException {
        if (schedulingInfoOptional && this.schedulingInfo == null) {
            return;
        }
        if (this.schedulingInfo == null) {
            throw new InvalidJobException("No scheduling info provided");
        }
        if (this.schedulingInfo.getStages() == null) {
            throw new InvalidJobException("No stages defined in scheduling info");
        }
        int numStages = this.schedulingInfo.getStages().size();
        int startingIdx = 1;
        if (this.schedulingInfo.forStage(0) != null) {
            startingIdx = 0;
            --numStages;
        }
        for (int i = startingIdx; i <= numStages; ++i) {
            StageSchedulingInfo stage = this.schedulingInfo.getStages().get(i);
            if (stage == null) {
                throw new InvalidJobException("No definition for stage " + i + " in scheduling info for " + numStages + " stage job");
            }
            if (stage.getNumberOfInstances() < 1) {
                throw new InvalidJobException("Number of instance for stage " + i + " must be >0, not " + stage.getNumberOfInstances());
            }
            MachineDefinition machineDefinition = stage.getMachineDefinition();
            if (machineDefinition.getCpuCores() <= 0.0) {
                throw new InvalidJobException("cpuCores must be >0.0, not " + machineDefinition.getCpuCores());
            }
            if (machineDefinition.getMemoryMB() <= 0.0) {
                throw new InvalidJobException("memory must be <0.0, not " + machineDefinition.getMemoryMB());
            }
            if (machineDefinition.getDiskMB() < 0.0) {
                throw new InvalidJobException("disk must be >=0, not " + machineDefinition.getDiskMB());
            }
            if (machineDefinition.getNumPorts() >= 0) continue;
            throw new InvalidJobException("numPorts must be >=0, not " + machineDefinition.getNumPorts());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getJobJarFileLocation() {
        return this.jobJarFileLocation;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public JobSla getJobSla() {
        return this.jobSla;
    }

    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public void setSchedulingInfo(SchedulingInfo schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    public int getSlaMin() {
        return this.slaMin;
    }

    public int getSlaMax() {
        return this.slaMax;
    }

    public String getCronSpec() {
        return this.cronSpec;
    }

    public NamedJobDefinition.CronPolicy getCronPolicy() {
        return this.cronPolicy;
    }

    public boolean getIsReadyForJobMaster() {
        return this.isReadyForJobMaster;
    }

    public WorkerMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public String toString() {
        return "MantisJobDefinition{name='" + this.name + '\'' + ", user='" + this.user + '\'' + ", jobJarFileLocation=" + this.jobJarFileLocation + ", version='" + this.version + '\'' + ", parameters=" + this.parameters + ", labels=" + this.labels + ", jobSla=" + this.jobSla + ", subscriptionTimeoutSecs=" + this.subscriptionTimeoutSecs + ", schedulingInfo=" + this.schedulingInfo + ", slaMin=" + this.slaMin + ", slaMax=" + this.slaMax + ", cronSpec='" + this.cronSpec + '\'' + ", cronPolicy=" + (Object)((Object)this.cronPolicy) + ", isReadyForJobMaster=" + this.isReadyForJobMaster + ", migrationConfig=" + this.migrationConfig + '}';
    }
}

