/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.runtime.MantisJobDurationType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSla {
    public static final String uniqueTagName = "unique";
    private static final Logger logger = LoggerFactory.getLogger(JobSla.class);
    private final long runtimeLimitSecs;
    private final long minRuntimeSecs;
    private final StreamSLAType slaType;
    private final MantisJobDurationType durationType;
    private final String userProvidedType;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobSla(@JsonProperty(value="runtimeLimitSecs") long runtimeLimitSecs, @JsonProperty(value="minRuntimeSecs") long minRuntimeSecs, @JsonProperty(value="slaType") StreamSLAType slaType, @JsonProperty(value="durationType") MantisJobDurationType durationType, @JsonProperty(value="userProvidedType") String userProvidedType) {
        this.runtimeLimitSecs = Math.max(0L, runtimeLimitSecs);
        this.minRuntimeSecs = Math.max(0L, minRuntimeSecs);
        this.slaType = slaType == null ? StreamSLAType.Lossy : slaType;
        this.durationType = durationType;
        this.userProvidedType = userProvidedType;
    }

    public long getRuntimeLimitSecs() {
        return this.runtimeLimitSecs;
    }

    public long getMinRuntimeSecs() {
        return this.minRuntimeSecs;
    }

    public StreamSLAType getSlaType() {
        return this.slaType;
    }

    public MantisJobDurationType getDurationType() {
        return this.durationType;
    }

    public String getUserProvidedType() {
        return this.userProvidedType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.durationType == null ? 0 : this.durationType.hashCode());
        result = 31 * result + (int)(this.minRuntimeSecs ^ this.minRuntimeSecs >>> 32);
        result = 31 * result + (int)(this.runtimeLimitSecs ^ this.runtimeLimitSecs >>> 32);
        result = 31 * result + (this.slaType == null ? 0 : this.slaType.hashCode());
        result = 31 * result + (this.userProvidedType == null ? 0 : this.userProvidedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobSla other = (JobSla)obj;
        if (this.durationType != other.durationType) {
            return false;
        }
        if (this.minRuntimeSecs != other.minRuntimeSecs) {
            return false;
        }
        if (this.runtimeLimitSecs != other.runtimeLimitSecs) {
            return false;
        }
        if (this.slaType != other.slaType) {
            return false;
        }
        return !(this.userProvidedType == null ? other.userProvidedType != null : !this.userProvidedType.equals(other.userProvidedType));
    }

    public String toString() {
        return "JobSla [runtimeLimitSecs=" + this.runtimeLimitSecs + ", minRuntimeSecs=" + this.minRuntimeSecs + ", slaType=" + (Object)((Object)this.slaType) + ", durationType=" + (Object)((Object)this.durationType) + ", userProvidedType=" + this.userProvidedType + "]";
    }

    public static class Builder {
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private long runtimeLimit = 0L;
        private long minRuntimeSecs = 0L;
        private StreamSLAType slaType = StreamSLAType.Lossy;
        private MantisJobDurationType durationType = MantisJobDurationType.Perpetual;
        private Map<String, String> userProvidedTypes = new HashMap<String, String>();

        public Builder withRuntimeLimit(long limit2) {
            this.runtimeLimit = limit2;
            return this;
        }

        public Builder withMinRuntimeSecs(long minRuntimeSecs) {
            this.minRuntimeSecs = minRuntimeSecs;
            return this;
        }

        public Builder withSlaType(StreamSLAType slaType) {
            this.slaType = slaType;
            return this;
        }

        public Builder withDurationType(MantisJobDurationType durationType) {
            this.durationType = durationType;
            return this;
        }

        public Builder withUniqueJobTagValue(String value) {
            this.userProvidedTypes.put(JobSla.uniqueTagName, value);
            return this;
        }

        public Builder withUserTag(String key2, String value) {
            this.userProvidedTypes.put(key2, value);
            return this;
        }

        public JobSla build() {
            try {
                return new JobSla(this.runtimeLimit, this.minRuntimeSecs, this.slaType, this.durationType, objectMapper.writeValueAsString(this.userProvidedTypes));
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException("Unexpected error creating json out of user tags map: " + e2.getMessage(), e2);
            }
        }
    }

    public static enum StreamSLAType {
        Lossy;

    }
}

