/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.Compiler;
import io.mantisrx.mql.shaded.clojure.lang.RT;
import io.mantisrx.mql.shaded.clojure.lang.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class Reflector {
    public static Object invokeInstanceMethod(Object target, String methodName, Object[] args) {
        Class<?> c = target.getClass();
        List methods2 = Reflector.getMethods(c, args.length, methodName, false);
        return Reflector.invokeMatchingMethod(methodName, methods2, target, args);
    }

    private static Throwable getCauseOrElse(Exception e2) {
        if (e2.getCause() != null) {
            return e2.getCause();
        }
        return e2;
    }

    private static RuntimeException throwCauseOrElseException(Exception e2) {
        if (e2.getCause() != null) {
            throw Util.sneakyThrow(e2.getCause());
        }
        throw Util.sneakyThrow(e2);
    }

    private static String noMethodReport(String methodName, Object target) {
        return "No matching method found: " + methodName + (target == null ? "" : " for " + target.getClass());
    }

    static Object invokeMatchingMethod(String methodName, List methods2, Object target, Object[] args) {
        Method m32 = null;
        Object[] boxedArgs = null;
        if (methods2.isEmpty()) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target));
        }
        if (methods2.size() == 1) {
            m32 = (Method)methods2.get(0);
            boxedArgs = Reflector.boxArgs(m32.getParameterTypes(), args);
        } else {
            Method foundm = null;
            for (Method m32 : methods2) {
                Class[] params = m32.getParameterTypes();
                if (!Reflector.isCongruent(params, args) || foundm != null && !Compiler.subsumes(params, foundm.getParameterTypes())) continue;
                foundm = m32;
                boxedArgs = Reflector.boxArgs(params, args);
            }
            m32 = foundm;
        }
        if (m32 == null) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target));
        }
        if (!Modifier.isPublic(m32.getDeclaringClass().getModifiers())) {
            Method oldm = m32;
            m32 = Reflector.getAsMethodOfPublicBase(target.getClass(), m32);
            if (m32 == null) {
                throw new IllegalArgumentException("Can't call public method of non-public class: " + oldm.toString());
            }
        }
        try {
            return Reflector.prepRet(m32.getReturnType(), m32.invoke(target, boxedArgs));
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(Reflector.getCauseOrElse(e2));
        }
    }

    public static Method getAsMethodOfPublicBase(Class c, Method m3) {
        for (Class<?> iface : c.getInterfaces()) {
            for (Method im : iface.getMethods()) {
                if (!Reflector.isMatch(im, m3)) continue;
                return im;
            }
        }
        Class sc = c.getSuperclass();
        if (sc == null) {
            return null;
        }
        for (Method scm : sc.getMethods()) {
            if (!Reflector.isMatch(scm, m3)) continue;
            return scm;
        }
        return Reflector.getAsMethodOfPublicBase(sc, m3);
    }

    public static boolean isMatch(Method lhs, Method rhs) {
        Class<?>[] types2;
        if (!lhs.getName().equals(rhs.getName()) || !Modifier.isPublic(lhs.getDeclaringClass().getModifiers())) {
            return false;
        }
        Class<?>[] types1 = lhs.getParameterTypes();
        if (types1.length != (types2 = rhs.getParameterTypes()).length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i].isAssignableFrom(types2[i])) continue;
            match = false;
            break;
        }
        return match;
    }

    public static Object invokeConstructor(Class c, Object[] args) {
        try {
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList<Constructor> ctors = new ArrayList<Constructor>();
            for (int i = 0; i < allctors.length; ++i) {
                Constructor ctor = allctors[i];
                if (ctor.getParameterTypes().length != args.length) continue;
                ctors.add(ctor);
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            if (ctors.size() == 1) {
                Constructor ctor = (Constructor)ctors.get(0);
                return ctor.newInstance(Reflector.boxArgs(ctor.getParameterTypes(), args));
            }
            for (Constructor ctor : ctors) {
                Class[] params = ctor.getParameterTypes();
                if (!Reflector.isCongruent(params, args)) continue;
                Object[] boxedArgs = Reflector.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            throw new IllegalArgumentException("No matching ctor found for " + c);
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(Reflector.getCauseOrElse(e2));
        }
    }

    public static Object invokeStaticMethodVariadic(String className, String methodName, Object ... args) {
        return Reflector.invokeStaticMethod(className, methodName, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) {
        Class c = RT.classForName(className);
        return Reflector.invokeStaticMethod(c, methodName, args);
    }

    public static Object invokeStaticMethod(Class c, String methodName, Object[] args) {
        if (methodName.equals("new")) {
            return Reflector.invokeConstructor(c, args);
        }
        List methods2 = Reflector.getMethods(c, args.length, methodName, true);
        return Reflector.invokeMatchingMethod(methodName, methods2, null, args);
    }

    public static Object getStaticField(String className, String fieldName) {
        Class c = RT.classForName(className);
        return Reflector.getStaticField(c, fieldName);
    }

    public static Object getStaticField(Class c, String fieldName) {
        Field f = Reflector.getField(c, fieldName, true);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(null));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + c);
    }

    public static Object setStaticField(String className, String fieldName, Object val2) {
        Class c = RT.classForName(className);
        return Reflector.setStaticField(c, fieldName, val2);
    }

    public static Object setStaticField(Class c, String fieldName, Object val2) {
        Field f = Reflector.getField(c, fieldName, true);
        if (f != null) {
            try {
                f.set(null, Reflector.boxArg(f.getType(), val2));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return val2;
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + c);
    }

    public static Object getInstanceField(Object target, String fieldName) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, fieldName, false);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(target));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + target.getClass());
    }

    public static Object setInstanceField(Object target, String fieldName, Object val2) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, fieldName, false);
        if (f != null) {
            try {
                f.set(target, Reflector.boxArg(f.getType(), val2));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return val2;
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + target.getClass());
    }

    public static Object invokeNoArgInstanceMember(Object target, String name2) {
        return Reflector.invokeNoArgInstanceMember(target, name2, false);
    }

    public static Object invokeNoArgInstanceMember(Object target, String name2, boolean requireField) {
        Class<?> c = target.getClass();
        if (requireField) {
            Field f = Reflector.getField(c, name2, false);
            if (f != null) {
                return Reflector.getInstanceField(target, name2);
            }
            throw new IllegalArgumentException("No matching field found: " + name2 + " for " + target.getClass());
        }
        List meths = Reflector.getMethods(c, 0, name2, false);
        if (meths.size() > 0) {
            return Reflector.invokeMatchingMethod(name2, meths, target, RT.EMPTY_ARRAY);
        }
        return Reflector.getInstanceField(target, name2);
    }

    public static Object invokeInstanceMember(Object target, String name2) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, name2, false);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(target));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        return Reflector.invokeInstanceMethod(target, name2, RT.EMPTY_ARRAY);
    }

    public static Object invokeInstanceMember(String name2, Object target, Object arg1) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, name2, false);
        if (f != null) {
            try {
                f.set(target, Reflector.boxArg(f.getType(), arg1));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return arg1;
        }
        return Reflector.invokeInstanceMethod(target, name2, new Object[]{arg1});
    }

    public static Object invokeInstanceMember(String name2, Object target, Object ... args) {
        return Reflector.invokeInstanceMethod(target, name2, args);
    }

    public static Field getField(Class c, String name2, boolean getStatics) {
        Field[] allfields = c.getFields();
        for (int i = 0; i < allfields.length; ++i) {
            if (!name2.equals(allfields[i].getName()) || Modifier.isStatic(allfields[i].getModifiers()) != getStatics) continue;
            return allfields[i];
        }
        return null;
    }

    public static List getMethods(Class c, int arity, String name2, boolean getStatics) {
        int i;
        Method[] allmethods = c.getMethods();
        ArrayList<Method> methods2 = new ArrayList<Method>();
        ArrayList<Method> bridgeMethods = new ArrayList<Method>();
        for (i = 0; i < allmethods.length; ++i) {
            Method method = allmethods[i];
            if (!name2.equals(method.getName()) || Modifier.isStatic(method.getModifiers()) != getStatics || method.getParameterTypes().length != arity) continue;
            try {
                if (method.isBridge() && c.getMethod(method.getName(), method.getParameterTypes()).equals(method)) {
                    bridgeMethods.add(method);
                    continue;
                }
                methods2.add(method);
                continue;
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        if (methods2.isEmpty()) {
            methods2.addAll(bridgeMethods);
        }
        if (!getStatics && c.isInterface()) {
            allmethods = Object.class.getMethods();
            for (i = 0; i < allmethods.length; ++i) {
                if (!name2.equals(allmethods[i].getName()) || Modifier.isStatic(allmethods[i].getModifiers()) != getStatics || allmethods[i].getParameterTypes().length != arity) continue;
                methods2.add(allmethods[i]);
            }
        }
        return methods2;
    }

    static Object boxArg(Class paramType, Object arg) {
        if (!paramType.isPrimitive()) {
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            if (paramType == Integer.TYPE) {
                return n.intValue();
            }
            if (paramType == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (paramType == Double.TYPE) {
                return n.doubleValue();
            }
            if (paramType == Long.TYPE) {
                return n.longValue();
            }
            if (paramType == Short.TYPE) {
                return n.shortValue();
            }
            if (paramType == Byte.TYPE) {
                return n.byteValue();
            }
        }
        throw new IllegalArgumentException("Unexpected param type, expected: " + paramType + ", given: " + arg.getClass().getName());
    }

    static Object[] boxArgs(Class[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object arg = args[i];
            Class paramType = params[i];
            ret[i] = Reflector.boxArg(paramType, arg);
        }
        return ret;
    }

    public static boolean paramArgTypeMatch(Class paramType, Class argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Integer.TYPE) {
            return argType == Integer.class || argType == Long.TYPE || argType == Long.class || argType == Short.TYPE || argType == Byte.TYPE;
        }
        if (paramType == Float.TYPE) {
            return argType == Float.class || argType == Double.TYPE;
        }
        if (paramType == Double.TYPE) {
            return argType == Double.class || argType == Float.TYPE;
        }
        if (paramType == Long.TYPE) {
            return argType == Long.class || argType == Integer.TYPE || argType == Short.TYPE || argType == Byte.TYPE;
        }
        if (paramType == Character.TYPE) {
            return argType == Character.class;
        }
        if (paramType == Short.TYPE) {
            return argType == Short.class;
        }
        if (paramType == Byte.TYPE) {
            return argType == Byte.class;
        }
        if (paramType == Boolean.TYPE) {
            return argType == Boolean.class;
        }
        return false;
    }

    static boolean isCongruent(Class[] params, Object[] args) {
        boolean ret = false;
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            ret = true;
            for (int i = 0; ret && i < params.length; ++i) {
                Object arg = args[i];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class paramType = params[i];
                ret = Reflector.paramArgTypeMatch(paramType, argType);
            }
        }
        return ret;
    }

    public static Object prepRet(Class c, Object x) {
        if (!c.isPrimitive() && c != Boolean.class) {
            return x;
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? Boolean.TRUE : Boolean.FALSE;
        }
        return x;
    }
}

