/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.rx;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class MonitorOperator<T>
implements Observable.Operator<T, T> {
    private static Logger logger = LoggerFactory.getLogger(MonitorOperator.class);
    private final Counter next;
    private final Gauge nextGauge;
    private final Gauge error;
    private final Gauge complete;
    private final Gauge subscribe;
    private String name;

    public MonitorOperator(String name2) {
        this.name = name2;
        Metrics m3 = new Metrics.Builder().name(name2).addCounter("onNext").addGauge("onError").addGauge("onComplete").addGauge("subscribe").addGauge("onNextGauge").build();
        m3 = MetricsRegistry.getInstance().registerAndGet(m3);
        this.next = m3.getCounter("onNext");
        this.error = m3.getGauge("onError");
        this.complete = m3.getGauge("onComplete");
        this.subscribe = m3.getGauge("subscribe");
        this.nextGauge = m3.getGauge("onNextGauge");
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> o) {
        this.subscribe.increment();
        o.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                MonitorOperator.this.subscribe.decrement();
            }
        }));
        return new Subscriber<T>(o){

            @Override
            public void onCompleted() {
                logger.debug("onCompleted() called for monitored observable with name: " + MonitorOperator.this.name);
                MonitorOperator.this.complete.increment();
                o.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                logger.error("onError() called for monitored observable with name: " + MonitorOperator.this.name, e2);
                MonitorOperator.this.error.increment();
                o.onError(e2);
            }

            @Override
            public void onNext(T t) {
                MonitorOperator.this.next.increment();
                MonitorOperator.this.nextGauge.set(MonitorOperator.this.next.value());
                o.onNext(t);
            }
        };
    }
}

