/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.netty.TcpClientListener;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.HttpClientMetricEventsListener;

public class HttpClientListener
extends TcpClientListener<ClientMetricsEvent<?>> {
    private final Gauge requestBacklog;
    private final Gauge inflightRequests;
    private final Counter processedRequests;
    private final Counter requestWriteFailed;
    private final Counter failedResponses;
    private final HttpClientMetricEventsListenerImpl delegate = new HttpClientMetricEventsListenerImpl();

    protected HttpClientListener(String monitorId) {
        super(monitorId);
        String metricsGroup = "httpClient";
        String idValue = Optional.ofNullable(monitorId).orElse("none");
        BasicTag idTag = new BasicTag("groupId", idValue);
        Metrics m3 = new Metrics.Builder().id("httpClient", new Tag[]{idTag}).addGauge("requestBacklog").addGauge("inflightRequests").addCounter("processedRequests").addCounter("requestWriteFailed").addCounter("failedResponses").build();
        this.requestBacklog = m3.getGauge("requestBacklog");
        this.inflightRequests = m3.getGauge("inflightRequests");
        this.processedRequests = m3.getCounter("processedRequests");
        this.requestWriteFailed = m3.getCounter("requestWriteFailed");
        this.failedResponses = m3.getCounter("failedResponses");
    }

    public static HttpClientListener newHttpListener(String monitorId) {
        return new HttpClientListener(monitorId);
    }

    @Override
    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return (long)this.requestBacklog.doubleValue();
    }

    public long getInflightRequests() {
        return (long)this.inflightRequests.doubleValue();
    }

    public long getProcessedRequests() {
        return this.processedRequests.value();
    }

    public long getRequestWriteFailed() {
        return this.requestWriteFailed.value();
    }

    public long getFailedResponses() {
        return this.failedResponses.value();
    }

    private class HttpClientMetricEventsListenerImpl
    extends HttpClientMetricEventsListener {
        private HttpClientMetricEventsListenerImpl() {
        }

        @Override
        protected void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        }

        @Override
        protected void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.inflightRequests.decrement();
            HttpClientListener.this.processedRequests.increment();
        }

        @Override
        protected void onResponseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.inflightRequests.decrement();
            HttpClientListener.this.processedRequests.increment();
            HttpClientListener.this.failedResponses.increment();
        }

        @Override
        protected void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        }

        @Override
        protected void onRequestContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.requestWriteFailed.increment();
        }

        @Override
        protected void onRequestHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.requestWriteFailed.increment();
        }

        @Override
        protected void onRequestHeadersWriteStart() {
            HttpClientListener.this.requestBacklog.decrement();
        }

        @Override
        protected void onRequestSubmitted() {
            HttpClientListener.this.requestBacklog.increment();
            HttpClientListener.this.inflightRequests.increment();
        }

        @Override
        protected void onByteRead(long bytesRead) {
            HttpClientListener.this.onByteRead(bytesRead);
        }

        @Override
        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onFlushSuccess(duration, timeUnit);
        }

        @Override
        protected void onFlushStart() {
            HttpClientListener.this.onFlushStart();
        }

        @Override
        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpClientListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        @Override
        protected void onWriteStart() {
            HttpClientListener.this.onWriteStart();
        }

        @Override
        protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolReleaseFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolReleaseSuccess(duration, timeUnit);
        }

        @Override
        protected void onPoolReleaseStart() {
            HttpClientListener.this.onPoolReleaseStart();
        }

        @Override
        protected void onPooledConnectionEviction() {
            HttpClientListener.this.onPooledConnectionEviction();
        }

        @Override
        protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPooledConnectionReuse(duration, timeUnit);
        }

        @Override
        protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolAcquireFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolAcquireSuccess(duration, timeUnit);
        }

        @Override
        protected void onPoolAcquireStart() {
            HttpClientListener.this.onPoolAcquireStart();
        }

        @Override
        protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectionCloseFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectionCloseSuccess(duration, timeUnit);
        }

        @Override
        protected void onConnectionCloseStart() {
            HttpClientListener.this.onConnectionCloseStart();
        }

        @Override
        protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectFailed(duration, timeUnit, throwable);
        }

        @Override
        protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectSuccess(duration, timeUnit);
        }

        @Override
        protected void onConnectStart() {
            HttpClientListener.this.onConnectStart();
        }
    }
}

