/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.compression;

import io.mantisrx.common.MantisServerSentEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class CompressionUtils {
    public static final String MANTIS_SSE_DELIMITER = "$$$";
    public static final byte[] MANTIS_SSE_DELIMITER_BINARY = "$$$".getBytes();
    private static Logger logger = LoggerFactory.getLogger(CompressionUtils.class);

    public static String compressAndBase64Encode(List<String> events, boolean useSnappy) {
        if (!events.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String event : events) {
                sb.append(event);
                sb.append(MANTIS_SSE_DELIMITER);
            }
            try {
                byte[] compressedBytes = useSnappy ? CompressionUtils.snappyCompressData(sb.toString()) : CompressionUtils.gzipCompressData(sb.toString());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData;
            }
            catch (UnsupportedEncodingException e2) {
                logger.warn("Error encoding messages:" + e2.getMessage());
            }
            catch (IOException e3) {
                logger.warn("Error encoding messages2:" + e3.getMessage());
            }
        }
        return null;
    }

    public static String compressAndBase64Encode(List<String> events) {
        return CompressionUtils.compressAndBase64Encode(events, false);
    }

    public static byte[] compressAndBase64EncodeBytes(List<List<byte[]>> nestedEvents, boolean useSnappy) {
        if (!nestedEvents.isEmpty()) {
            ByteBuffer buffer = ByteBuffer.allocate(CompressionUtils.getTotalByteSize(nestedEvents));
            for (List<byte[]> outerList : nestedEvents) {
                for (byte[] event : outerList) {
                    buffer.put(event);
                    buffer.put(MANTIS_SSE_DELIMITER_BINARY);
                }
            }
            try {
                byte[] compressedBytes = useSnappy ? CompressionUtils.snappyCompressData(buffer.array()) : CompressionUtils.gzipCompressData(buffer.array());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                logger.warn("Error encoding messages:" + e2.getMessage());
            }
            catch (IOException e3) {
                logger.warn("Error encoding messages2:" + e3.getMessage());
            }
        }
        return null;
    }

    @Deprecated
    public static byte[] compressAndBase64EncodeBytes(List<List<byte[]>> nestedEvents) {
        if (!nestedEvents.isEmpty()) {
            ByteBuffer buffer = ByteBuffer.allocate(CompressionUtils.getTotalByteSize(nestedEvents));
            for (List<byte[]> outerList : nestedEvents) {
                for (byte[] event : outerList) {
                    buffer.put(event);
                    buffer.put(MANTIS_SSE_DELIMITER_BINARY);
                }
            }
            try {
                byte[] compressedBytes = CompressionUtils.gzipCompressData(buffer.array());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                logger.warn("Error encoding messages:" + e2.getMessage());
            }
            catch (IOException e3) {
                logger.warn("Error encoding messages2:" + e3.getMessage());
            }
        }
        return null;
    }

    private static int getTotalByteSize(List<List<byte[]>> nestedEvents) {
        int size = 0;
        int count2 = 0;
        for (List<byte[]> outerList : nestedEvents) {
            for (byte[] event : outerList) {
                ++count2;
                size += event.length;
            }
        }
        return size + count2 * MANTIS_SSE_DELIMITER_BINARY.length;
    }

    public static List<MantisServerSentEvent> decompressAndBase64Decode_old(String encodedString, boolean isCompressedBinary) {
        if (!(encodedString = encodedString.trim()).isEmpty() && isCompressedBinary && !encodedString.startsWith("ping") && !encodedString.startsWith("{")) {
            if (logger.isDebugEnabled()) {
                logger.debug("decoding " + encodedString);
            }
            byte[] decoded = Base64.getDecoder().decode(encodedString);
            try {
                String line;
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(decoded));
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
                String outStr = "";
                while ((line = bf.readLine()) != null) {
                    outStr = outStr + line;
                }
                String[] toks2 = outStr.split("\\$\\$\\$");
                ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
                for (String tok : toks2) {
                    msseList.add(new MantisServerSentEvent(tok));
                }
                return msseList;
            }
            catch (IOException e2) {
                logger.error(e2.getMessage());
                return new ArrayList<MantisServerSentEvent>();
            }
        }
        ArrayList<MantisServerSentEvent> s2 = new ArrayList<MantisServerSentEvent>();
        s2.add(new MantisServerSentEvent(encodedString));
        return s2;
    }

    static List<MantisServerSentEvent> tokenize(BufferedReader bf) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        int dollarCnt = 0;
        while ((line = bf.readLine()) != null) {
            for (int i = 0; i < line.length(); ++i) {
                if (dollarCnt == 3) {
                    msseList.add(new MantisServerSentEvent(sb.toString()));
                    dollarCnt = 0;
                    sb = new StringBuilder();
                }
                if (line.charAt(i) != '$') {
                    sb.append(line.charAt(i));
                    continue;
                }
                ++dollarCnt;
            }
        }
        if (sb.length() > 0) {
            msseList.add(new MantisServerSentEvent(sb.toString()));
        }
        return msseList;
    }

    static List<MantisServerSentEvent> tokenize_1(BufferedReader bf) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        String outStr = "";
        while ((line = bf.readLine()) != null) {
            sb.append(line);
        }
        int i = 0;
        outStr = sb.toString();
        sb = new StringBuilder();
        while (i < outStr.length()) {
            while (outStr.charAt(i) != '$') {
                sb.append(outStr.charAt(i));
                ++i;
            }
            if (i + 3 < outStr.length()) {
                if (outStr.charAt(i) != '$' || outStr.charAt(i + 1) != '$' || outStr.charAt(i + 2) != '$') continue;
                i += 3;
                msseList.add(new MantisServerSentEvent(sb.toString()));
                sb = new StringBuilder();
                continue;
            }
            sb.append(outStr.charAt(i));
            ++i;
        }
        return msseList;
    }

    static List<MantisServerSentEvent> tokenize_2(BufferedReader bf) throws IOException {
        String[] toks2;
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        String outStr = "";
        while ((line = bf.readLine()) != null) {
            sb.append(line);
        }
        outStr = sb.toString();
        for (String tok : toks2 = outStr.split("\\$\\$\\$")) {
            msseList.add(new MantisServerSentEvent(tok));
        }
        return msseList;
    }

    public static List<MantisServerSentEvent> decompressAndBase64Decode(String encodedString, boolean isCompressedBinary, boolean useSnappy) {
        if (!(encodedString = encodedString.trim()).isEmpty() && isCompressedBinary && !encodedString.startsWith("ping") && !encodedString.startsWith("{")) {
            if (logger.isDebugEnabled()) {
                logger.debug("decoding " + encodedString);
            }
            byte[] decoded = Base64.getDecoder().decode(encodedString);
            try {
                if (useSnappy) {
                    return CompressionUtils.tokenize(CompressionUtils.snappyDecompress(decoded));
                }
                return CompressionUtils.tokenize(CompressionUtils.gzipDecompress(decoded));
            }
            catch (IOException e2) {
                logger.error(e2.getMessage());
                return new ArrayList<MantisServerSentEvent>();
            }
        }
        ArrayList<MantisServerSentEvent> s2 = new ArrayList<MantisServerSentEvent>();
        s2.add(new MantisServerSentEvent(encodedString));
        return s2;
    }

    @Deprecated
    public static List<MantisServerSentEvent> decompressAndBase64Decode(String encodedString, boolean isCompressedBinary) {
        return CompressionUtils.decompressAndBase64Decode(encodedString, isCompressedBinary, false);
    }

    static byte[] snappyCompressData(String data2) throws IOException {
        return Snappy.compress(data2);
    }

    static byte[] snappyCompressData(byte[] data2) throws IOException {
        return Snappy.compress(data2);
    }

    static byte[] gzipCompressData(String data2) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(data2.getBytes("UTF-8"));
        gzip.close();
        byte[] compressedBytes = obj.toByteArray();
        return compressedBytes;
    }

    static byte[] gzipCompressData(byte[] data2) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(data2);
        gzip.close();
        byte[] compressedBytes = obj.toByteArray();
        return compressedBytes;
    }

    static BufferedReader snappyDecompress(byte[] data2) throws IOException {
        byte[] decompressed = Snappy.uncompress(data2);
        ByteArrayInputStream bais = new ByteArrayInputStream(decompressed);
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)bais, "UTF-8"));
        return bf;
    }

    static BufferedReader gzipDecompress(byte[] data2) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data2));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        return bf;
    }

    public static void main(String[] args) {
        String d = "{\"ip\":\"50.112.119.64\",\"count\":27}$$${\\\"ip\\\":\\\"50.112.119.64\\\",\\\"count\\\":27}";
        String e1 = "{\"ip\":\"11.112.119.64\",\"count\":27}";
        String e2 = "{\"ip\":\"22.111.112.62\",\"count\":27}";
        String e3 = "{\"ip\":\"33.222.112.62\",\"count\":27}";
        ArrayList<String> events = new ArrayList<String>();
        events.add(e1);
        events.add(e2);
        events.add(e3);
        String encodedString = CompressionUtils.compressAndBase64Encode(events);
        List<MantisServerSentEvent> orig = CompressionUtils.decompressAndBase64Decode(encodedString, true);
        for (MantisServerSentEvent event : orig) {
            System.out.println("event -> " + event);
        }
    }
}

