/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@GwtCompatible
public final class AtomicLongMap<K>
implements Serializable {
    private final ConcurrentHashMap<K, Long> map;
    private transient @MonotonicNonNull Map<K, Long> asMap;

    private AtomicLongMap(ConcurrentHashMap<K, Long> map2) {
        this.map = Preconditions.checkNotNull(map2);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> m3) {
        AtomicLongMap<? extends K> result = AtomicLongMap.create();
        result.putAll(m3);
        return result;
    }

    public long get(K key2) {
        return this.map.getOrDefault(key2, 0L);
    }

    @CanIgnoreReturnValue
    public long incrementAndGet(K key2) {
        return this.addAndGet(key2, 1L);
    }

    @CanIgnoreReturnValue
    public long decrementAndGet(K key2) {
        return this.addAndGet(key2, -1L);
    }

    @CanIgnoreReturnValue
    public long addAndGet(K key2, long delta) {
        return this.accumulateAndGet(key2, delta, Long::sum);
    }

    @CanIgnoreReturnValue
    public long getAndIncrement(K key2) {
        return this.getAndAdd(key2, 1L);
    }

    @CanIgnoreReturnValue
    public long getAndDecrement(K key2) {
        return this.getAndAdd(key2, -1L);
    }

    @CanIgnoreReturnValue
    public long getAndAdd(K key2, long delta) {
        return this.getAndAccumulate(key2, delta, Long::sum);
    }

    @CanIgnoreReturnValue
    public long updateAndGet(K key2, LongUnaryOperator updaterFunction) {
        Preconditions.checkNotNull(updaterFunction);
        return this.map.compute(key2, (k, value) -> updaterFunction.applyAsLong(value == null ? 0L : value));
    }

    @CanIgnoreReturnValue
    public long getAndUpdate(K key2, LongUnaryOperator updaterFunction) {
        Preconditions.checkNotNull(updaterFunction);
        AtomicLong holder = new AtomicLong();
        this.map.compute(key2, (k, value) -> {
            long oldValue = value == null ? 0L : value;
            holder.set(oldValue);
            return updaterFunction.applyAsLong(oldValue);
        });
        return holder.get();
    }

    @CanIgnoreReturnValue
    public long accumulateAndGet(K key2, long x, LongBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(key2, oldValue -> accumulatorFunction.applyAsLong(oldValue, x));
    }

    @CanIgnoreReturnValue
    public long getAndAccumulate(K key2, long x, LongBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(key2, oldValue -> accumulatorFunction.applyAsLong(oldValue, x));
    }

    @CanIgnoreReturnValue
    public long put(K key2, long newValue) {
        return this.getAndUpdate(key2, x -> newValue);
    }

    public void putAll(Map<? extends K, ? extends Long> m3) {
        m3.forEach(this::put);
    }

    @CanIgnoreReturnValue
    public long remove(K key2) {
        Long result = this.map.remove(key2);
        return result == null ? 0L : result;
    }

    boolean remove(K key2, long value) {
        return this.map.remove(key2, value);
    }

    @Beta
    @CanIgnoreReturnValue
    public boolean removeIfZero(K key2) {
        return this.remove(key2, 0L);
    }

    public void removeAllZeros() {
        this.map.values().removeIf(x -> x == 0L);
    }

    public long sum() {
        return this.map.values().stream().mapToLong(Long::longValue).sum();
    }

    public Map<K, Long> asMap() {
        Map<K, Long> result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    long putIfAbsent(K key2, long newValue) {
        AtomicBoolean noValue = new AtomicBoolean(false);
        Long result = this.map.compute(key2, (k, oldValue) -> {
            if (oldValue == null || oldValue == 0L) {
                noValue.set(true);
                return newValue;
            }
            return oldValue;
        });
        return noValue.get() ? 0L : result;
    }

    boolean replace(K key2, long expectedOldValue, long newValue) {
        if (expectedOldValue == 0L) {
            return this.putIfAbsent(key2, newValue) == 0L;
        }
        return this.map.replace(key2, expectedOldValue, newValue);
    }
}

