/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SuperSonicBeanDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBeanDeserializer(BeanDeserializer src, List<SettableBeanProperty> props) {
        super(src);
        int len = props.size();
        this._orderedPropertyNames = new SerializedString[len];
        for (int i = 0; i < len; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(props.get(i).getName());
        }
    }

    protected SuperSonicBeanDeserializer(SuperSonicBeanDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
        this._orderedProperties = src._orderedProperties;
        this._orderedPropertyNames = src._orderedPropertyNames;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return new SuperSonicBeanDeserializer(this, unwrapper);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        int i;
        super.resolve(ctxt);
        if (this._externalTypeIdHandler != null || this._unwrappedPropertyHandler != null) {
            return;
        }
        int len = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(len);
        for (i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._beanProperties.find(this._orderedPropertyNames[i].toString());
            if (prop == null) continue;
            props.add(prop);
        }
        if (i == 0) {
            throw new IllegalStateException("Afterburner internal error: BeanDeserializer for " + this._beanType + " has no properties that match expected ordering (should have " + len + ") -- can not create optimized deserializer");
        }
        this._orderedProperties = props.toArray(new SettableBeanProperty[props.size()]);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object id;
        if (!this._vanillaProcessing || this._objectIdReader != null) {
            return super.deserialize(p, ctxt);
        }
        if (!p.isExpectedStartObjectToken()) {
            return this._deserializeOther(p, ctxt, p.getCurrentToken());
        }
        if (this._nonStandardCreation) {
            p.nextToken();
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean2 = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean2);
            }
            return bean2;
        }
        Object bean3 = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean3);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean3, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean3);
        }
        int len = this._orderedProperties.length;
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._orderedProperties[i];
            if (!p.nextFieldName(this._orderedPropertyNames[i])) {
                if (p.getCurrentToken() == JsonToken.END_OBJECT) {
                    return bean3;
                }
                return super.deserialize(p, ctxt, bean3);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean3);
                continue;
            }
            catch (Exception e2) {
                this.wrapAndThrow(e2, bean3, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean3);
        }
        return bean3;
    }

    @Override
    public final Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        p.setCurrentValue(bean2);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean2);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean2);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean2);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextFieldName(this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.FIELD_NAME) || !prop.getName().equals(p.getCurrentName())) {
            return super.deserialize(p, ctxt, bean2);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean2);
        }
        catch (Exception e2) {
            this.wrapAndThrow(e2, bean2, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            if (!p.nextFieldName(this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean2;
                }
                return super.deserialize(p, ctxt, bean2);
            }
            prop = this._orderedProperties[i];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean2);
                continue;
            }
            catch (Exception e3) {
                this.wrapAndThrow(e3, bean2, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean2);
        }
        return bean2;
    }

    @Override
    public final Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object id;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.getCurrentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean2 = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean2);
            }
            return bean2;
        }
        Object bean3 = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean3);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean3, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean3);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextFieldName(this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.FIELD_NAME) || !prop.getName().equals(p.getCurrentName())) {
            return super.deserialize(p, ctxt, bean3);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean3);
        }
        catch (Exception e2) {
            this.wrapAndThrow(e2, bean3, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            prop = this._orderedProperties[i];
            if (!p.nextFieldName(this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean3;
                }
                return super.deserialize(p, ctxt, bean3);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean3);
                continue;
            }
            catch (Exception e3) {
                this.wrapAndThrow(e3, bean3, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean3);
        }
        return bean3;
    }
}

