/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableStringFieldProperty
extends OptimizedSettableBeanProperty<SettableStringFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableStringFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index2) {
        super(src, mutator, index2);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableStringFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        String text;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            text = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            text = p.getValueAsString();
            if (text == null) {
                text = this._deserializeString(p, ctxt);
            }
        }
        try {
            this._propertyMutator.stringField(bean2, this._optimizedIndex, text);
        }
        catch (Throwable e2) {
            this._reportProblem(bean2, text, e2);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        String text;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            text = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            text = p.getValueAsString();
            if (text == null) {
                text = this._deserializeString(p, ctxt);
            }
        }
        return this.setAndReturn(instance, text);
    }

    @Override
    public void set(Object bean2, Object value) throws IOException {
        String text = (String)value;
        try {
            this._propertyMutator.stringField(bean2, this._optimizedIndex, text);
        }
        catch (Throwable e2) {
            this._reportProblem(bean2, text, e2);
        }
    }
}

