/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableBooleanMethodProperty
extends OptimizedSettableBeanProperty<SettableBooleanMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableBooleanMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index2) {
        super(src, mutator, index2);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableBooleanMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        JsonToken t = p.getCurrentToken();
        boolean b = t == JsonToken.VALUE_TRUE ? true : (t == JsonToken.VALUE_FALSE ? false : this._deserializeBoolean(p, ctxt));
        try {
            this._propertyMutator.booleanSetter(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e2) {
            this._reportProblem(bean2, b, e2);
        }
    }

    @Override
    public void set(Object bean2, Object value) throws IOException {
        boolean b = (Boolean)value;
        try {
            this._propertyMutator.booleanSetter(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e2) {
            this._reportProblem(bean2, b, e2);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        JsonToken t = p.getCurrentToken();
        boolean b = t == JsonToken.VALUE_TRUE ? true : (t == JsonToken.VALUE_FALSE ? false : this._deserializeBoolean(p, ctxt));
        return this.setAndReturn(instance, b);
    }
}

