/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleBeanPropertyFilter
implements BeanPropertyFilter,
PropertyFilter {
    protected SimpleBeanPropertyFilter() {
    }

    public static SimpleBeanPropertyFilter serializeAll() {
        return SerializeExceptFilter.INCLUDE_ALL;
    }

    @Deprecated
    public static SimpleBeanPropertyFilter serializeAll(Set<String> properties2) {
        return new FilterExceptFilter(properties2);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(Set<String> properties2) {
        return new FilterExceptFilter(properties2);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(String ... propertyArray) {
        HashSet<String> properties2 = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties2, propertyArray);
        return new FilterExceptFilter(properties2);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(Set<String> properties2) {
        return new SerializeExceptFilter(properties2);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(String ... propertyArray) {
        HashSet<String> properties2 = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties2, propertyArray);
        return new SerializeExceptFilter(properties2);
    }

    public static PropertyFilter from(final BeanPropertyFilter src) {
        return new PropertyFilter(){

            @Override
            public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer2) throws Exception {
                src.serializeAsField(pojo, jgen, prov, (BeanPropertyWriter)writer2);
            }

            @Override
            public void depositSchemaProperty(PropertyWriter writer2, ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
                src.depositSchemaProperty((BeanPropertyWriter)writer2, propertiesNode, provider);
            }

            @Override
            public void depositSchemaProperty(PropertyWriter writer2, JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
                src.depositSchemaProperty((BeanPropertyWriter)writer2, objectVisitor, provider);
            }

            @Override
            public void serializeAsElement(Object elementValue, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer2) throws Exception {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean include(BeanPropertyWriter writer2) {
        return true;
    }

    protected boolean include(PropertyWriter writer2) {
        return true;
    }

    protected boolean includeElement(Object elementValue) {
        return true;
    }

    @Override
    @Deprecated
    public void serializeAsField(Object bean2, JsonGenerator jgen, SerializerProvider provider, BeanPropertyWriter writer2) throws Exception {
        if (this.include(writer2)) {
            writer2.serializeAsField(bean2, jgen, provider);
        } else if (!jgen.canOmitFields()) {
            writer2.serializeAsOmittedField(bean2, jgen, provider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter writer2, ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
        if (this.include(writer2)) {
            writer2.depositSchemaProperty(propertiesNode, provider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter writer2, JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        if (this.include(writer2)) {
            writer2.depositSchemaProperty(objectVisitor, provider);
        }
    }

    @Override
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer2) throws Exception {
        if (this.include(writer2)) {
            writer2.serializeAsField(pojo, jgen, provider);
        } else if (!jgen.canOmitFields()) {
            writer2.serializeAsOmittedField(pojo, jgen, provider);
        }
    }

    @Override
    public void serializeAsElement(Object elementValue, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer2) throws Exception {
        if (this.includeElement(elementValue)) {
            writer2.serializeAsElement(elementValue, jgen, provider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(PropertyWriter writer2, ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
        if (this.include(writer2)) {
            writer2.depositSchemaProperty(propertiesNode, provider);
        }
    }

    @Override
    public void depositSchemaProperty(PropertyWriter writer2, JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        if (this.include(writer2)) {
            writer2.depositSchemaProperty(objectVisitor, provider);
        }
    }

    public static class SerializeExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final SerializeExceptFilter INCLUDE_ALL = new SerializeExceptFilter();
        protected final Set<String> _propertiesToExclude;

        SerializeExceptFilter() {
            this._propertiesToExclude = Collections.emptySet();
        }

        public SerializeExceptFilter(Set<String> properties2) {
            this._propertiesToExclude = properties2;
        }

        @Override
        protected boolean include(BeanPropertyWriter writer2) {
            return !this._propertiesToExclude.contains(writer2.getName());
        }

        @Override
        protected boolean include(PropertyWriter writer2) {
            return !this._propertiesToExclude.contains(writer2.getName());
        }
    }

    public static class FilterExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Set<String> _propertiesToInclude;

        public FilterExceptFilter(Set<String> properties2) {
            this._propertiesToInclude = properties2;
        }

        @Override
        protected boolean include(BeanPropertyWriter writer2) {
            return this._propertiesToInclude.contains(writer2.getName());
        }

        @Override
        protected boolean include(PropertyWriter writer2) {
            return this._propertiesToInclude.contains(writer2.getName());
        }
    }
}

