/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.measurement.CounterMeasurement;
import io.mantisrx.common.metrics.measurement.GaugeMeasurement;
import io.mantisrx.common.metrics.measurement.Measurements;
import io.mantisrx.common.metrics.spectator.MetricId;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.protocol.http.server.HttpServer;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.server.RequestHandler;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class MetricsServer {
    private static final Logger logger = LoggerFactory.getLogger(MetricsServer.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private HttpServer<ByteBuf, ServerSentEvent> server;
    private int port;
    private Map<String, String> tags;
    private long publishRateInSeconds;

    public MetricsServer(int port, long publishRateInSeconds, Map<String, String> tags) {
        this.port = port;
        this.publishRateInSeconds = publishRateInSeconds;
        this.tags = tags;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.registerModule((Module)new Jdk8Module());
    }

    private Observable<Measurements> measurements(long timeFrequency) {
        final MetricsRegistry registry = MetricsRegistry.getInstance();
        return Observable.interval((long)0L, (long)timeFrequency, (TimeUnit)TimeUnit.SECONDS).flatMap((Func1)new Func1<Long, Observable<Measurements>>(){

            public Observable<Measurements> call(Long t1) {
                long timestamp = System.currentTimeMillis();
                ArrayList<Measurements> measurements = new ArrayList<Measurements>();
                for (Metrics metrics : registry.metrics()) {
                    LinkedList<CounterMeasurement> counters = new LinkedList<CounterMeasurement>();
                    LinkedList<GaugeMeasurement> gauges = new LinkedList<GaugeMeasurement>();
                    for (Map.Entry<MetricId, Counter> entry : metrics.counters().entrySet()) {
                        Counter counter = entry.getValue();
                        counters.add(new CounterMeasurement(entry.getKey().metricName(), counter.value()));
                    }
                    for (Map.Entry<MetricId, Object> entry : metrics.gauges().entrySet()) {
                        gauges.add(new GaugeMeasurement(entry.getKey().metricName(), ((Gauge)entry.getValue()).doubleValue()));
                    }
                    measurements.add(new Measurements(metrics.getMetricGroupId().id(), timestamp, counters, gauges, MetricsServer.this.tags));
                }
                return Observable.from(measurements);
            }
        });
    }

    public void start() {
        final Observable<Measurements> measurements = this.measurements(this.publishRateInSeconds);
        logger.info("Starting metrics server on port: " + this.port);
        this.server = RxNetty.createHttpServer((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ServerSentEvent>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, final HttpServerResponse<ServerSentEvent> response) {
                Map queryParameters = request.getQueryParameters();
                final LinkedList namesToFilter = new LinkedList();
                logger.info("got query params {}", (Object)queryParameters);
                if (queryParameters != null && queryParameters.containsKey("name")) {
                    namesToFilter.addAll((Collection)queryParameters.get("name"));
                }
                Observable filteredObservable = measurements.filter((Func1)new Func1<Measurements, Boolean>(){

                    public Boolean call(Measurements measurements) {
                        if (!namesToFilter.isEmpty()) {
                            for (String name : namesToFilter) {
                                if (name.indexOf(42) != -1) {
                                    if (name.indexOf(42) == 0 && measurements.getName().endsWith(name.substring(1))) {
                                        return true;
                                    }
                                    if (name.indexOf(42) > 0 && measurements.getName().startsWith(name.substring(0, name.indexOf(42)))) {
                                        return true;
                                    }
                                }
                                if (!measurements.getName().equals(name)) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                });
                return filteredObservable.flatMap((Func1)new Func1<Measurements, Observable<Void>>(){

                    public Observable<Void> call(Measurements metrics) {
                        response.getHeaders().set("Access-Control-Allow-Origin", (Object)"*");
                        response.getHeaders().set("content-type", (Object)"text/event-stream");
                        ServerSentEvent event = null;
                        try {
                            ByteBuf data = response.getAllocator().buffer().writeBytes(MetricsServer.this.mapper.writeValueAsString((Object)metrics).getBytes());
                            event = new ServerSentEvent(data);
                        }
                        catch (JsonProcessingException e) {
                            logger.error("Failed to map metrics to JSON", (Throwable)e);
                        }
                        if (event != null) {
                            response.write(event);
                            return response.writeStringAndFlush("\n");
                        }
                        return null;
                    }
                });
            }
        }, (PipelineConfigurator)PipelineConfigurators.serveSseConfigurator()).start();
    }

    public void shutdown() {
        if (this.server != null) {
            logger.info("Shutting down metrics server on port");
            logger.info("Waiting (2 x push-period) to flush buffers, before shut down.");
            try {
                TimeUnit.SECONDS.sleep(2L);
                this.server.shutdown();
            }
            catch (InterruptedException e) {
                logger.warn("Failed to shutdown metrics server", (Throwable)e);
            }
        }
    }
}

