/*
 * Decompiled with CFR 0.152.
 */
package com.mantisrx.common.utils;

import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.util.concurrent.Service;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Logger log = LoggerFactory.getLogger(Services.class);

    public static CompletableFuture<Void> startAsync(Service service, Executor executor) {
        Preconditions.checkArgument((service.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"Assumes the service has not been started yet");
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        service.addListener(new Service.Listener(){

            public void running() {
                result.complete(null);
            }

            public void failed(Service.State from, Throwable failure) {
                if (from.ordinal() < Service.State.RUNNING.ordinal()) {
                    result.completeExceptionally(failure);
                }
            }
        }, executor);
        service.startAsync();
        return result;
    }

    public static CompletableFuture<Void> awaitAsync(Service service, Executor executor) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        service.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                result.complete(null);
            }

            public void failed(Service.State from, Throwable failure) {
                result.completeExceptionally(failure);
            }
        }, executor);
        if (service.state() == Service.State.FAILED) {
            result.completeExceptionally(service.failureCause());
        } else if (service.state() == Service.State.TERMINATED) {
            result.complete(null);
        }
        return result;
    }

    public static CompletableFuture<Void> stopAsync(Service service, Executor executor) {
        CompletableFuture<Void> result = Services.awaitAsync(service, executor);
        service.stopAsync();
        return result;
    }

    public static void startAndWait(Service service) {
        try {
            service.startAsync();
        }
        catch (IllegalStateException e) {
            log.warn("Service already started: {}", (Object)service);
        }
        service.awaitRunning();
    }
}

