/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.common.properties.DefaultMantisPropertiesLoader;
import io.mantisrx.common.properties.MantisPropertiesLoader;
import java.beans.ConstructorProperties;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry {
    private static Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private final AtomicReference<State> registryRef = new AtomicReference<Object>(null);
    public static ServiceRegistry INSTANCE = new ServiceRegistry();

    private ServiceRegistry() {
    }

    public void setMantisPropertiesService(MantisPropertiesLoader service) {
        logger.debug("Setting Mantis Properties Service to {}", (Object)service);
        if (!this.registryRef.compareAndSet(null, new State(service, new Exception()))) {
            logger.error("MantisPropertiesService already set to {} as part of the below stacktrace", (Object)this.registryRef.get().getPropertiesLoader(), (Object)this.registryRef.get().getStackTrace());
        }
    }

    public MantisPropertiesLoader getPropertiesService() {
        if (this.registryRef.get() == null) {
            this.setMantisPropertiesService(ServiceRegistry.loadMantisPropertiesLoader());
        }
        return this.registryRef.get().getPropertiesLoader();
    }

    private static MantisPropertiesLoader loadMantisPropertiesLoader() {
        MantisPropertiesLoader mpl = new DefaultMantisPropertiesLoader(new Properties());
        try {
            mpl = (MantisPropertiesLoader)Class.forName("com.netflix.mantis.common.properties.MantisFastPropertiesLoader").getConstructor(Properties.class).newInstance(new Properties());
        }
        catch (Exception e) {
            logger.warn("Could not load MantisFastPropertiesLoader");
        }
        return mpl;
    }

    final class State {
        private final MantisPropertiesLoader propertiesLoader;
        private final Exception stackTrace;

        @ConstructorProperties(value={"propertiesLoader", "stackTrace"})
        public State(MantisPropertiesLoader propertiesLoader, Exception stackTrace) {
            this.propertiesLoader = propertiesLoader;
            this.stackTrace = stackTrace;
        }

        public MantisPropertiesLoader getPropertiesLoader() {
            return this.propertiesLoader;
        }

        public Exception getStackTrace() {
            return this.stackTrace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            MantisPropertiesLoader this$propertiesLoader = this.getPropertiesLoader();
            MantisPropertiesLoader other$propertiesLoader = other.getPropertiesLoader();
            if (this$propertiesLoader == null ? other$propertiesLoader != null : !this$propertiesLoader.equals(other$propertiesLoader)) {
                return false;
            }
            Exception this$stackTrace = this.getStackTrace();
            Exception other$stackTrace = other.getStackTrace();
            return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MantisPropertiesLoader $propertiesLoader = this.getPropertiesLoader();
            result = result * 59 + ($propertiesLoader == null ? 43 : $propertiesLoader.hashCode());
            Exception $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            return result;
        }

        public String toString() {
            return "ServiceRegistry.State(propertiesLoader=" + this.getPropertiesLoader() + ", stackTrace=" + this.getStackTrace() + ")";
        }
    }
}

