/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.runtime.descriptor.StageDeploymentStrategy;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeploymentStrategy {
    private final Map<Integer, StageDeploymentStrategy> stageDeploymentStrategyMap;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String resourceClusterId;

    public DeploymentStrategy(@JsonProperty(value="stageDeploymentStrategyMap") Map<Integer, StageDeploymentStrategy> stageDeploymentStrategyMap, @JsonProperty(value="resourceClusterId") String resourceClusterId) {
        this.stageDeploymentStrategyMap = stageDeploymentStrategyMap;
        this.resourceClusterId = resourceClusterId;
    }

    public StageDeploymentStrategy forStage(int stageNum) {
        if (!this.stageDeploymentStrategyMap.containsKey(stageNum)) {
            return null;
        }
        return this.stageDeploymentStrategyMap.get(stageNum);
    }

    public boolean requireInheritInstanceCheck() {
        return this.stageDeploymentStrategyMap != null && this.stageDeploymentStrategyMap.values().stream().anyMatch(StageDeploymentStrategy::isInheritInstanceCount);
    }

    public boolean requireInheritInstanceCheck(int stageNum) {
        return this.stageDeploymentStrategyMap != null && this.stageDeploymentStrategyMap.containsKey(stageNum) && this.stageDeploymentStrategyMap.get(stageNum).isInheritInstanceCount();
    }

    public static DeploymentStrategyBuilder builder() {
        return new DeploymentStrategyBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentStrategy)) {
            return false;
        }
        DeploymentStrategy other = (DeploymentStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, StageDeploymentStrategy> this$stageDeploymentStrategyMap = this.getStageDeploymentStrategyMap();
        Map<Integer, StageDeploymentStrategy> other$stageDeploymentStrategyMap = other.getStageDeploymentStrategyMap();
        if (this$stageDeploymentStrategyMap == null ? other$stageDeploymentStrategyMap != null : !((Object)this$stageDeploymentStrategyMap).equals(other$stageDeploymentStrategyMap)) {
            return false;
        }
        String this$resourceClusterId = this.getResourceClusterId();
        String other$resourceClusterId = other.getResourceClusterId();
        return !(this$resourceClusterId == null ? other$resourceClusterId != null : !this$resourceClusterId.equals(other$resourceClusterId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeploymentStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, StageDeploymentStrategy> $stageDeploymentStrategyMap = this.getStageDeploymentStrategyMap();
        result = result * 59 + ($stageDeploymentStrategyMap == null ? 43 : ((Object)$stageDeploymentStrategyMap).hashCode());
        String $resourceClusterId = this.getResourceClusterId();
        result = result * 59 + ($resourceClusterId == null ? 43 : $resourceClusterId.hashCode());
        return result;
    }

    public String toString() {
        return "DeploymentStrategy(stageDeploymentStrategyMap=" + this.getStageDeploymentStrategyMap() + ", resourceClusterId=" + this.getResourceClusterId() + ")";
    }

    public Map<Integer, StageDeploymentStrategy> getStageDeploymentStrategyMap() {
        return this.stageDeploymentStrategyMap;
    }

    public String getResourceClusterId() {
        return this.resourceClusterId;
    }

    public static class DeploymentStrategyBuilder {
        private ArrayList<Integer> stageDeploymentStrategyMap$key;
        private ArrayList<StageDeploymentStrategy> stageDeploymentStrategyMap$value;
        private String resourceClusterId;

        DeploymentStrategyBuilder() {
        }

        public DeploymentStrategyBuilder stage(Integer stageKey, StageDeploymentStrategy stageValue) {
            if (this.stageDeploymentStrategyMap$key == null) {
                this.stageDeploymentStrategyMap$key = new ArrayList();
                this.stageDeploymentStrategyMap$value = new ArrayList();
            }
            this.stageDeploymentStrategyMap$key.add(stageKey);
            this.stageDeploymentStrategyMap$value.add(stageValue);
            return this;
        }

        public DeploymentStrategyBuilder stageDeploymentStrategyMap(Map<? extends Integer, ? extends StageDeploymentStrategy> stageDeploymentStrategyMap) {
            if (stageDeploymentStrategyMap != null) {
                if (this.stageDeploymentStrategyMap$key == null) {
                    this.stageDeploymentStrategyMap$key = new ArrayList();
                    this.stageDeploymentStrategyMap$value = new ArrayList();
                }
                for (Map.Entry<? extends Integer, ? extends StageDeploymentStrategy> $lombokEntry : stageDeploymentStrategyMap.entrySet()) {
                    this.stageDeploymentStrategyMap$key.add($lombokEntry.getKey());
                    this.stageDeploymentStrategyMap$value.add($lombokEntry.getValue());
                }
            }
            return this;
        }

        public DeploymentStrategyBuilder clearStageDeploymentStrategyMap() {
            if (this.stageDeploymentStrategyMap$key != null) {
                this.stageDeploymentStrategyMap$key.clear();
                this.stageDeploymentStrategyMap$value.clear();
            }
            return this;
        }

        public DeploymentStrategyBuilder resourceClusterId(String resourceClusterId) {
            this.resourceClusterId = resourceClusterId;
            return this;
        }

        public DeploymentStrategy build() {
            Map<Integer, StageDeploymentStrategy> stageDeploymentStrategyMap;
            switch (this.stageDeploymentStrategyMap$key == null ? 0 : this.stageDeploymentStrategyMap$key.size()) {
                case 0: {
                    stageDeploymentStrategyMap = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stageDeploymentStrategyMap = Collections.singletonMap(this.stageDeploymentStrategyMap$key.get(0), this.stageDeploymentStrategyMap$value.get(0));
                    break;
                }
                default: {
                    stageDeploymentStrategyMap = new LinkedHashMap<Integer, StageDeploymentStrategy>(this.stageDeploymentStrategyMap$key.size() < 0x40000000 ? 1 + this.stageDeploymentStrategyMap$key.size() + (this.stageDeploymentStrategyMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stageDeploymentStrategyMap$key.size(); ++$i) {
                        stageDeploymentStrategyMap.put(this.stageDeploymentStrategyMap$key.get($i), this.stageDeploymentStrategyMap$value.get($i));
                    }
                    stageDeploymentStrategyMap = Collections.unmodifiableMap(stageDeploymentStrategyMap);
                }
            }
            return new DeploymentStrategy(stageDeploymentStrategyMap, this.resourceClusterId);
        }

        public String toString() {
            return "DeploymentStrategy.DeploymentStrategyBuilder(stageDeploymentStrategyMap$key=" + this.stageDeploymentStrategyMap$key + ", stageDeploymentStrategyMap$value=" + this.stageDeploymentStrategyMap$value + ", resourceClusterId=" + this.resourceClusterId + ")";
        }
    }
}

