/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectatorRegistryFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpectatorRegistryFactory.class);
    private static final AtomicReference<Registry> registryRef = new AtomicReference<Object>(null);

    public static Registry getRegistry() {
        if (registryRef.get() == null) {
            return Spectator.globalRegistry();
        }
        return registryRef.get();
    }

    public static void setRegistry(Registry registry) {
        if (registry != null && registryRef.compareAndSet(null, registry)) {
            logger.info("spectator registry : {}", (Object)registryRef.get().getClass().getCanonicalName());
        }
    }
}

