/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics;

import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;

public abstract class MetricsPublisher {
    protected Map<String, String> commonTags = new HashMap<String, String>();
    private Properties properties;
    private Subscription subscription;

    public MetricsPublisher(Properties properties) {
        this.properties = properties;
    }

    protected Properties getPropertis() {
        return this.properties;
    }

    public void start(int pollMetricsRegistryFrequencyInSeconds, Map<String, String> commonTags) {
        this.commonTags.putAll(commonTags);
        final MetricsRegistry registry = MetricsRegistry.getInstance();
        this.subscription = Observable.interval((long)0L, (long)pollMetricsRegistryFrequencyInSeconds, (TimeUnit)TimeUnit.SECONDS).doOnNext((Action1)new Action1<Long>(){

            public void call(Long t1) {
                long timestamp = System.currentTimeMillis();
                MetricsPublisher.this.publishMetrics(timestamp, registry.metrics());
            }
        }).subscribe();
    }

    public void start(int pollMetricsRegistryFrequencyInSeconds) {
        this.start(pollMetricsRegistryFrequencyInSeconds, new HashMap<String, String>());
    }

    public void shutdown() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    public abstract void publishMetrics(long var1, Collection<Metrics> var3);
}

