/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.impl.AtomicDouble;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.spectator.MetricId;

public class GaugeImpl
implements Gauge {
    private final MetricId metricId;
    private String event;
    private AtomicDouble value;

    public GaugeImpl(MetricId metricId, Registry registry) {
        this.metricId = metricId;
        Id spectatorId = metricId.getSpectatorId(registry);
        this.value = (AtomicDouble)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(spectatorId)).monitorValue((Number)new AtomicDouble());
        this.event = spectatorId.toString();
    }

    @Override
    public String event() {
        return this.event;
    }

    @Override
    public MetricId id() {
        return this.metricId;
    }

    @Override
    public long value() {
        return this.value.longValue();
    }

    @Override
    public void set(double value) {
        this.value.set(value);
    }

    @Override
    public void increment() {
        this.value.addAndGet(1.0);
    }

    @Override
    public void increment(double delta) {
        this.value.addAndGet(delta);
    }

    @Override
    public void decrement() {
        this.value.getAndAdd(-1.0);
    }

    @Override
    public void decrement(double delta) {
        this.value.getAndAdd(-1.0 * delta);
    }

    @Override
    public double doubleValue() {
        return this.value.get();
    }

    @Override
    public void set(long x) {
        this.value.set((double)x);
    }

    @Override
    public void increment(long x) {
        this.value.getAndAdd((double)x);
    }

    @Override
    public void decrement(long x) {
        this.value.getAndAdd(-1.0 * (double)x);
    }
}

