/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;
import rx.functions.Action1;

public class Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(Endpoint.class);
    final String slotId;
    private final String host;
    private final int port;
    private final Action0 completedCallback;
    private final Action1<Throwable> errorCallback;

    public Endpoint(String host, int port) {
        this(host, port, Endpoint.uniqueHost(host, port, null));
    }

    public Endpoint(final String host, final int port, final String slotId) {
        this(host, port, slotId, new Action0(){

            public void call() {
                logger.info("onComplete received for {}:{} slotId {}", new Object[]{host, port, slotId});
            }
        }, new Action1<Throwable>(){

            public void call(Throwable t1) {
                logger.warn("onError for {}:{} slotId {} err {}", new Object[]{host, port, slotId, t1.getMessage(), t1});
            }
        });
    }

    public Endpoint(String host, int port, Action0 completedCallback, Action1<Throwable> errorCallback) {
        this(host, port, Endpoint.uniqueHost(host, port, null), completedCallback, errorCallback);
    }

    public Endpoint(String host, int port, String slotId, Action0 completedCallback, Action1<Throwable> errorCallback) {
        this.host = host;
        this.port = port;
        this.slotId = slotId;
        this.completedCallback = completedCallback;
        this.errorCallback = errorCallback;
    }

    public static String uniqueHost(String host, int port, String slotId) {
        if (slotId == null) {
            return host + ":" + port;
        }
        return host + ":" + port + ":" + slotId;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Action0 getCompletedCallback() {
        return this.completedCallback;
    }

    public Action1<Throwable> getErrorCallback() {
        return this.errorCallback;
    }

    public String toString() {
        return "Endpoint{host='" + this.host + '\'' + ", port=" + this.port + ", slotId='" + this.slotId + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.slotId == null ? 0 : this.slotId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.slotId == null ? other.slotId != null : !this.slotId.equals(other.slotId));
    }
}

