/*
 * Copyright 2019 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mantisrx.common.utils;

public class MantisSourceJobConstants {

    public static final String SUBSCRIPTION_ID_PARAM_NAME = "subscriptionId";
    public static final String CRITERION_PARAM_NAME = "criterion";

    public static final String FILTER_PARAM_NAME = "filter";


    public static final String TARGET_APP_PARAMETER_NAME = "targetApp";

    public static final String TARGET_ASG_CSV_PARAM = "targetASGs";

    public static final String TARGET_SERVER_READ_TIMEOUT_SECS = "targetReadTimeoutSecs";

    public static final String ECHO_STAGE_BUFFER_MILLIS = "bufferDurationMillis";

    public static final String REGION_PARAMETER_NAME = "region";

    public static final String ENABLE_COMPRESSED_BINARY_INPUT_PARAMETER_NAME = "enableCompressedBinaryInput";

    public static final String DECODE_INCOMING_DATA = "enableDecoding";
    public static final String DECODE_FIELD_SUFFIX = "decodeSuffix";

    public static final String ZONE_LIST_PARAMETER_NAME = "zoneList";
    public static final String SOURCE_JOB_NAME_KEY = "sourceJobName";
    public static final String TARGET_APP_NAME_KEY = "targetApp";
    public static final String CLIENT_ID_PARAMETER_NAME = "clientId";


    public static final String MANTIS_META_SOURCE_NAME = "\"mantis.meta.sourceName\"";
    public static final String TARGET_KEY = "target";

    public static final String NOT_SET = "NOT_SET";
}
