/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.config.dynamic;

import io.mantisrx.common.properties.MantisPropertiesLoader;
import io.mantisrx.config.dynamic.DynamicProperty;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongDynamicProperty
extends DynamicProperty<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongDynamicProperty.class);

    public LongDynamicProperty(MantisPropertiesLoader propertiesLoader, String propertyName, Long defaultValue) {
        super(propertiesLoader, propertyName, defaultValue);
    }

    public LongDynamicProperty(MantisPropertiesLoader propertiesLoader, String propertyName, Long defaultValue, Clock clock) {
        super(propertiesLoader, propertyName, defaultValue, clock);
    }

    @Override
    protected Long convertFromString(String newStrVal) {
        try {
            return Long.parseLong(newStrVal);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("invalid long value: " + newStrVal);
        }
    }
}

